/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="ProcessUsage")
public class LinuxProcessUsageDependency
implements IDependency {
    @Override
    public void install() throws Exception {
        URL url = new URL("https://download.gamedash.io/daemon/dependency/versions/1/ProcessUsage-Linux");
        FileDownloader fileDownloader = new FileDownloader(LinuxProcessUsageDependency.getFile(), url);
        fileDownloader.download();
        LinuxProcessUsageDependency.getFile().setExecutable(true);
    }

    @Override
    public void uninstall() {
        LinuxProcessUsageDependency.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static File getFile() {
        String fileName = "ProcessUsage-Linux";
        return new File(FileSystem.getRootDirectory().getPath() + File.separator + fileName);
    }
}

