/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.authentication;

import com.gamedash.daemon.common.authentication.AuthenticationException;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import java.io.IOException;

public class Authentication {
    public static boolean isAuthenticated() throws Exception {
        return Authentication.hasCurrentToken() && Authentication.getCurrentToken().validate().isValid();
    }

    public static AuthenticationToken getToken(String token) {
        return new AuthenticationToken(token);
    }

    public static AuthenticationToken getCurrentToken() throws Exception {
        if (!Authentication.hasCurrentToken()) {
            throw new AuthenticationException("No token is set");
        }
        return new AuthenticationToken(Config.getDefaultFile().getValue("authentication.token"));
    }

    public static boolean hasCurrentToken() throws IOException, ConfigException {
        return Config.getDefaultFile().valueExists("authentication.token");
    }

    public static void setCurrentToken(AuthenticationToken token) throws IOException, ConfigException {
        Config.getDefaultFile().setValue("authentication.token", token.toString());
    }
}

