/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.remote.host.implementation.IRemoteFileSystemHostImplementation;
import com.gamedash.daemon.fileSystem.remote.user.session.RemoteFileSystemUserSession;
import com.gamedash.daemon.fileSystem.remote.user.session.RemoteFileSystemUserSessions;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import spark.Request;
import spark.Response;

public class GetAllSessions
extends Route<Object> {
    public GetAllSessions(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<Session> execute() throws Exception {
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (RemoteFileSystemUserSession session : RemoteFileSystemUserSessions.getAll()) {
            sessions.add(new Session(session));
        }
        return sessions;
    }

    private static class Session {
        @SerializedName(value="userName")
        private String userName;
        @SerializedName(value="implementation")
        private Implementation implementation;
        @SerializedName(value="socketHost")
        private String socketHost;
        @SerializedName(value="socketPort")
        private int socketPort;

        public Session(RemoteFileSystemUserSession session) {
            this.userName = session.getUser().getName();
            this.implementation = new Implementation(session.getHostImplementation());
            this.socketHost = session.getSocketAddress().getHostName();
            this.socketPort = session.getSocketAddress().getPort();
        }

        private static class Implementation {
            @SerializedName(value="name")
            private String name = "SFTP";

            public Implementation(IRemoteFileSystemHostImplementation implementation) {
            }
        }
    }
}

