/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunks;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.util.UUID;
import spark.Request;
import spark.Response;

public class WriteChunk
extends Route<Object> {
    private InputStream inputStream;

    public WriteChunk(Request request, Response response, InputStream inputStream) {
        super(request, response);
        this.inputStream = inputStream;
    }

    @Override
    public WriteChunkResult execute() throws Exception {
        UUID sessionId = UUID.fromString(this.getParameters().get("session_id").getValue());
        long chunkId = this.getParameters().get("chunk_id").getValue(Long.class);
        if (!Sessions.exists(sessionId)) {
            throw new Exception("Session does not exist");
        }
        Session session = Sessions.get(sessionId);
        Chunks chunks = session.getChunks();
        Chunk chunk = chunks.get(chunkId);
        if (chunk.hasReceived()) {
            throw new Exception("Already received chunk " + chunkId);
        }
        chunk.receive(this.inputStream);
        if (chunks.hasReceivedAll()) {
            chunks.merge();
            return new WriteChunkResult(true);
        }
        return new WriteChunkResult(false);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"session_id", "chunk_id"};
    }

    private static class WriteChunkResult {
        @SerializedName(value="hasReceivedAll")
        private boolean hasReceivedAll;

        public WriteChunkResult(boolean hasReceivedAll) {
            this.hasReceivedAll = hasReceivedAll;
        }
    }
}

