/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import spark.Request;
import spark.Response;

public class MakeExecutable
extends Route<String> {
    public MakeExecutable(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = File.fromBase64(this.getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(file.toPath(), permissions);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

