/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import spark.Request;
import spark.Response;

public class GetProperties
extends Route<Object> {
    public GetProperties(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        com.gamedash.daemon.fileSystem.file.File file = com.gamedash.daemon.fileSystem.file.File.fromBase64(this.getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        return new Result(file);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }

    private static class TimestampResult {
        @SerializedName(value="created")
        private final long created;
        @SerializedName(value="lastModified")
        private final long lastModified;

        TimestampResult(long created, long lastModified) {
            this.created = created;
            this.lastModified = lastModified;
        }
    }

    private static class Result {
        @SerializedName(value="size")
        private final long size;
        @SerializedName(value="isDirectory")
        private final boolean isDirectory;
        @SerializedName(value="timestamp")
        private final TimestampResult timestamp;

        Result(File file) throws IOException {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            this.size = file.length();
            this.isDirectory = file.isDirectory();
            this.timestamp = new TimestampResult(attributes.creationTime().toMillis() / 1000L, attributes.lastModifiedTime().toMillis() / 1000L);
        }
    }
}

