/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.JsonTransformer;
import com.gamedash.daemon.api.server.authentication.Authentication;
import com.gamedash.daemon.api.server.parameter.ParameterException;
import com.gamedash.daemon.api.server.route.RouteWrapper;
import com.gamedash.daemon.api.server.route.routes.GetTime;
import com.gamedash.daemon.api.server.route.routes.GetUptime;
import com.gamedash.daemon.api.server.route.routes.Ping;
import com.gamedash.daemon.api.server.route.routes.Root;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Append;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Copy;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Delete;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Exists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetProperties;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetRealPath;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.IsDirectory;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.MD5Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Read;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.SHA1Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Unzip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Write;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Move;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.GetContents;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.Walk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.Download;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.DownloadAsync;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.download.GetDownloadSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.MakeExecutable;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Zip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.Serve;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.UpdateAll;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.CreateSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.DeleteSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.GetSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.SessionExists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.WriteChunk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.DisconnectSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessions;
import com.gamedash.daemon.api.server.route.routes.fileSystem.remote.user.GetAllSessionsForUser;
import com.gamedash.daemon.api.server.route.routes.operatingSystem.linux.GetRelease;
import com.gamedash.daemon.api.server.route.routes.packageManager.InstallPackage;
import com.gamedash.daemon.api.server.route.routes.packageManager.UninstallPackage;
import com.gamedash.daemon.api.server.route.routes.process.Get;
import com.gamedash.daemon.api.server.route.routes.process.GetChildren;
import com.gamedash.daemon.api.server.route.routes.process.GetResourceUsage;
import com.gamedash.daemon.api.server.route.routes.process.Kill;
import com.gamedash.daemon.api.server.route.routes.process.LimitResources;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Create;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetAll;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.GetExitCode;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.HasExited;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.IsRunning;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Stop;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.GetOutput;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.SendInput;
import com.gamedash.daemon.api.server.route.routes.system.GetInfo;
import com.gamedash.daemon.api.server.route.routes.system.GetUsage;
import com.gamedash.daemon.api.server.route.routes.system.Reboot;
import com.gamedash.daemon.api.server.route.routes.system.Shutdown;
import com.gamedash.daemon.api.server.route.routes.system.environment.GetEnvironmentVariables;
import com.gamedash.daemon.api.server.route.routes.system.user.authentication.SetPassword;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.AssignPermissions;
import com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file.SetHomeDirectory;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;

public class Routes {
    private ApiServer apiServer;

    public Routes(ApiServer apiServer) {
        this.apiServer = apiServer;
    }

    public void register() {
        this.apiServer.getService().get("/", (request, response) -> {
            response.type("application/json");
            return new RouteWrapper(new Root(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/uptime", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetUptime(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/time", (request, response) -> new RouteWrapper(new GetTime(request, response)).execute());
        this.apiServer.getService().post("/ping", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Ping(request, response)).execute();
        });
        this.apiServer.getService().get("/system/usage", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetUsage(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/system/info", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetInfo(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/system/environment/variable/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetEnvironmentVariables(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/system/uptime", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.GetUptime(request, response)).execute();
        });
        this.apiServer.getService().post("/system/shutdown", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Shutdown(request, response)).execute();
        });
        this.apiServer.getService().post("/system/reboot", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Reboot(request, response)).execute();
        });
        this.apiServer.getService().post("/process/childprocess", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Create(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/childprocess/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetAll(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/childprocess/:id/isrunning", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new IsRunning(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/childprocess/:id/exitcode", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetExitCode(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/childprocess/:id/hasexited", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new HasExited(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/childprocess/:id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.childprocess.Exists(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().delete("/process/childprocess/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Stop(request, response)).execute();
        });
        this.apiServer.getService().delete("/process/childprocess/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Stop(request, response)).execute();
        });
        this.apiServer.getService().delete("/process/childprocess/:id/kill", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.childprocess.Kill(request, response)).execute();
        });
        this.apiServer.getService().post("/process/childprocess/:id/io/input", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SendInput(request, response)).execute();
        });
        this.apiServer.getService().get("/process/childprocess/:id/io/output", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetOutput(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.GetAll(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/process/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Get(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().delete("/process/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Kill(request, response)).execute();
        });
        this.apiServer.getService().get("/process/:id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.Exists(request, response)).execute();
        });
        this.apiServer.getService().put("/process/:id/resource/limit", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new LimitResources(request, response)).execute();
        });
        this.apiServer.getService().get("/process/:id/children", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetChildren(request, response)).execute();
        });
        this.apiServer.getService().get("/process/:id/resource/usage", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetResourceUsage(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/filesystem/file/group/zip", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Zip(request, response)).execute();
        });
        this.apiServer.getService().put("/filesystem/file/group/executable", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new MakeExecutable(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/realpath", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new GetRealPath(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/group/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Exists(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/filesystem/file/group/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Copy(request, response)).execute();
        });
        this.apiServer.getService().put("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Write(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/isdirectory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new IsDirectory(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/checksum/md5", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new MD5Checksum(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/checksum/sha1", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SHA1Checksum(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Copy(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.Create(request, response)).execute();
        });
        this.apiServer.getService().delete("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Delete(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/download", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Download(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/download/async", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new DownloadAsync(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/download/session/:session_id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetDownloadSession(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/filesystem/file/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Exists(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/filesystem/file/move", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.Move(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Read(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/properties", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetProperties(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().put("/filesystem/file/executable", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.MakeExecutable(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/size", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new GetSize(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/unzip", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Unzip(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Write(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/upload/session", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new CreateSession(request, response)).execute();
        });
        this.apiServer.getService().delete("/filesystem/file/upload/session/:session_id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new DeleteSession(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/upload/session/:session_id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new SessionExists(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/filesystem/file/upload/session/:session_id/chunk/:chunk_id/write", "multipart/form-data", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            request.raw().setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(""));
            Part chunkContentPart = request.raw().getPart("chunkContent");
            if (chunkContentPart == null) {
                throw new ParameterException("No file detected");
            }
            if (chunkContentPart.getSize() == 0L) {
                throw new ParameterException("Uploaded file is empty");
            }
            response.type("application/json");
            return new RouteWrapper(new WriteChunk(request, response, chunkContentPart.getInputStream())).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/filesystem/file/upload/session/:session_id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetSession(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().put("/filesystem/file/append", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Append(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/directory/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Copy(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/directory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Create(request, response)).execute();
        });
        this.apiServer.getService().delete("/filesystem/file/directory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Delete(request, response)).execute();
        });
        this.apiServer.getService().post("/filesystem/file/directory/move", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Move(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/directory/size", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.GetSize(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/directory/contents", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetContents(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/filesystem/file/directory/contents/walk", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Walk(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/network/port/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.network.port.GetAll(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/network/port/:number", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.network.port.Get(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/system/user/:name", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Create(request, response)).execute();
        });
        this.apiServer.getService().delete("/system/user/:name", (request, response) -> new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Delete(request, response)).execute());
        this.apiServer.getService().get("/system/user/:name/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Exists(request, response)).execute();
        });
        this.apiServer.getService().put("/system/user/:name/authentication/password", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SetPassword(request, response)).execute();
        });
        this.apiServer.getService().put("/system/user/:name/filesystem/file/home", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SetHomeDirectory(request, response)).execute();
        });
        this.apiServer.getService().put("/system/user/:name/filesystem/file/permission/assign", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new AssignPermissions(request, response)).execute();
        });
        this.apiServer.getService().put("/filesystem/file/hotlink/update/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new UpdateAll(request, response)).execute();
        });
        this.apiServer.getService().get("/filesystem/file/hotlink/:id/serve", (request, response) -> new RouteWrapper(new Serve(request, response)).execute());
        this.apiServer.getService().get("/filesystem/file/hotlink/:id/serve/*", (request, response) -> new RouteWrapper(new Serve(request, response)).execute());
        this.apiServer.getService().get("/filesystem/remote/user/:user_name/session/all", (request, response) -> {
            response.type("application/json");
            return new RouteWrapper(new GetAllSessionsForUser(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().get("/filesystem/remote/user/session/all", (request, response) -> {
            response.type("application/json");
            return new RouteWrapper(new GetAllSessions(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().delete("/filesystem/remote/user/:user_name/session", (request, response) -> {
            response.type("application/json");
            return new RouteWrapper(new DisconnectSession(request, response)).execute();
        }, new JsonTransformer());
        this.apiServer.getService().post("/packagemanager/:name/install", (request, response) -> new RouteWrapper(new InstallPackage(request, response)).execute());
        this.apiServer.getService().delete("/packagemanager/:name/uninstall", (request, response) -> new RouteWrapper(new UninstallPackage(request, response)).execute());
        this.apiServer.getService().get("/operatingSystem/linux/release", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetRelease(request, response)).execute();
        }, new JsonTransformer());
    }
}

