/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.handler.ClientsBox;
import com.corundumstudio.socketio.handler.EncoderHandler;
import com.corundumstudio.socketio.messages.PacketsMessage;
import com.corundumstudio.socketio.messages.XHROptionsMessage;
import com.corundumstudio.socketio.messages.XHRPostMessage;
import com.corundumstudio.socketio.protocol.PacketDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PollingTransport
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "polling";
    private static final Logger log = LoggerFactory.getLogger(PollingTransport.class);
    private final PacketDecoder decoder;
    private final ClientsBox clientsBox;
    private final AuthorizeHandler authorizeHandler;

    public PollingTransport(PacketDecoder decoder, AuthorizeHandler authorizeHandler, ClientsBox clientsBox) {
        this.decoder = decoder;
        this.authorizeHandler = authorizeHandler;
        this.clientsBox = clientsBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest req;
        QueryStringDecoder queryDecoder;
        List<String> transport;
        if (msg instanceof FullHttpRequest && (transport = (queryDecoder = new QueryStringDecoder((req = (FullHttpRequest)msg).uri())).parameters().get("transport")) != null && NAME.equals(transport.get(0))) {
            List<String> sid = queryDecoder.parameters().get("sid");
            List<String> j = queryDecoder.parameters().get("j");
            List<String> b64 = queryDecoder.parameters().get("b64");
            String origin = req.headers().get(HttpHeaderNames.ORIGIN);
            ctx.channel().attr(EncoderHandler.ORIGIN).set(origin);
            String userAgent = req.headers().get(HttpHeaderNames.USER_AGENT);
            ctx.channel().attr(EncoderHandler.USER_AGENT).set(userAgent);
            if (j != null && j.get(0) != null) {
                Integer index = Integer.valueOf(j.get(0));
                ctx.channel().attr(EncoderHandler.JSONP_INDEX).set(index);
            }
            if (b64 != null && b64.get(0) != null) {
                String flag = b64.get(0);
                if ("true".equals(flag)) {
                    flag = "1";
                } else if ("false".equals(flag)) {
                    flag = "0";
                }
                Integer enable = Integer.valueOf(flag);
                ctx.channel().attr(EncoderHandler.B64).set(enable == 1);
            }
            try {
                if (sid != null && sid.get(0) != null) {
                    UUID sessionId = UUID.fromString(sid.get(0));
                    this.handleMessage(req, sessionId, queryDecoder, ctx);
                } else {
                    ClientHead client = ctx.channel().attr(ClientHead.CLIENT).get();
                    this.handleMessage(req, client.getSessionId(), queryDecoder, ctx);
                }
            }
            finally {
                req.release();
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private void handleMessage(FullHttpRequest req, UUID sessionId, QueryStringDecoder queryDecoder, ChannelHandlerContext ctx) throws IOException {
        String origin = req.headers().get(HttpHeaderNames.ORIGIN);
        if (queryDecoder.parameters().containsKey("disconnect")) {
            ClientHead client = this.clientsBox.get(sessionId);
            client.onChannelDisconnect();
            ctx.channel().writeAndFlush(new XHRPostMessage(origin, sessionId));
        } else if (HttpMethod.POST.equals(req.method())) {
            this.onPost(sessionId, ctx, origin, req.content());
        } else if (HttpMethod.GET.equals(req.method())) {
            this.onGet(sessionId, ctx, origin);
        } else if (HttpMethod.OPTIONS.equals(req.method())) {
            this.onOptions(sessionId, ctx, origin);
        } else {
            log.error("Wrong {} method invocation for {}", (Object)req.method(), (Object)sessionId);
            this.sendError(ctx);
        }
    }

    private void onOptions(UUID sessionId, ChannelHandlerContext ctx, String origin) {
        ClientHead client = this.clientsBox.get(sessionId);
        if (client == null) {
            log.error("{} is not registered. Closing connection", (Object)sessionId);
            this.sendError(ctx);
            return;
        }
        ctx.channel().writeAndFlush(new XHROptionsMessage(origin, sessionId));
    }

    private void onPost(UUID sessionId, ChannelHandlerContext ctx, String origin, ByteBuf content) throws IOException {
        ClientHead client = this.clientsBox.get(sessionId);
        if (client == null) {
            log.error("{} is not registered. Closing connection", (Object)sessionId);
            this.sendError(ctx);
            return;
        }
        ctx.channel().writeAndFlush(new XHRPostMessage(origin, sessionId));
        Boolean b64 = ctx.channel().attr(EncoderHandler.B64).get();
        if (b64 != null && b64.booleanValue()) {
            Integer jsonIndex = ctx.channel().attr(EncoderHandler.JSONP_INDEX).get();
            content = this.decoder.preprocessJson(jsonIndex, content);
        }
        ctx.pipeline().fireChannelRead(new PacketsMessage(client, content, Transport.POLLING));
    }

    protected void onGet(UUID sessionId, ChannelHandlerContext ctx, String origin) {
        ClientHead client = this.clientsBox.get(sessionId);
        if (client == null) {
            log.error("{} is not registered. Closing connection", (Object)sessionId);
            this.sendError(ctx);
            return;
        }
        client.bindChannel(ctx.channel(), Transport.POLLING);
        this.authorizeHandler.connect(client);
    }

    private void sendError(ChannelHandlerContext ctx) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        ctx.channel().writeAndFlush(res).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        ClientHead client = this.clientsBox.get(channel);
        if (client != null && client.isTransportChannel(ctx.channel(), Transport.POLLING)) {
            log.debug("channel inactive {}", (Object)client.getSessionId());
            client.releasePollingChannel(channel);
        }
        super.channelInactive(ctx);
    }
}

