/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.response;

import com.schokkerit.restapi.client.ApiQuery;
import com.schokkerit.restapi.client.ApiQueryException;
import com.schokkerit.restapi.client.response.IQueryResponse;
import com.schokkerit.restapi.client.response.IQueryResponseErrorHandlerCallback;
import com.schokkerit.restapi.client.response.QueryResponseErrorHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class QueryResponseErrorHandlerManager<TQueryResponse extends IQueryResponse> {
    public ApiQuery query;
    private Deque<QueryResponseErrorHandler> handlers = new ArrayDeque<QueryResponseErrorHandler>();

    public QueryResponseErrorHandlerManager(ApiQuery query) {
        this.query = query;
        this.registerDefault();
    }

    public void registerHandler(IQueryResponseErrorHandlerCallback<TQueryResponse> callback) {
        this.registerHandler(new QueryResponseErrorHandler<TQueryResponse>(callback));
    }

    public void registerHandler(QueryResponseErrorHandler handler) {
        this.handlers.add(handler);
    }

    public void handleIncoming(TQueryResponse response) {
        Iterator<QueryResponseErrorHandler> iterator = this.handlers.descendingIterator();
        while (iterator.hasNext()) {
            QueryResponseErrorHandler handler = iterator.next();
            handler.execute(response);
        }
    }

    private void registerDefault() {
        this.registerHandler(new QueryResponseErrorHandler<IQueryResponse>(response -> {
            throw new ApiQueryException("Query returned " + response.getStatusCode());
        }));
    }
}

