/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.process;

import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;

public class WindowsBridgeResourceProcessUsage {
    private WindowsBridgeProcess process;

    public WindowsBridgeResourceProcessUsage(WindowsBridgeProcess process) {
        this.process = process;
    }

    public double getCpuPercentage() throws WindowsBridgeProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageCpuPercentage(this.process.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsDouble();
    }

    public long getRamMb() throws WindowsBridgeProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageRamMb(this.process.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsLong();
    }
}

