/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.crash;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.crash.GlobalCrashManager;
import com.gamedash.daemon.process.childProcess.crash.report.CrashReport;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCrashManagerWorker {
    private static Logger logger = LoggerFactory.getLogger(ChildProcess.class);
    private Thread thread;
    private int tickInterval = 5000;

    private void tick() {
        for (CrashReport report : GlobalCrashManager.getQueuedReports()) {
            try {
                report.send();
            }
            catch (Exception e) {
                if (report.getRetryCount() > 5) {
                    GlobalCrashManager.getQueuedReports().remove(report);
                }
                report.incrementRetryCount();
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
    }

    public void start() {
        logger.info("Starting global child process crash manager worker");
        this.thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.tick();
                        Thread.sleep(this.tickInterval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }
}

