/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.packages;

import com.gamedash.daemon.linux.packages.IDistro;
import com.gamedash.daemon.linux.packages.LinuxPackage;
import com.gamedash.daemon.linux.packages.LinuxPackageException;
import com.gamedash.daemon.linux.packages.LinuxPackageNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class Debian
implements IDistro {
    private LinuxPackage linuxPackage;

    public Debian(LinuxPackage linuxPackage) {
        this.linuxPackage = linuxPackage;
    }

    @Override
    public void install() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("apt-get", new String[]{"--yes", "--force-yes", "install", this.linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            if (childProcess.getExitCode() == 100) {
                throw new LinuxPackageNotFoundException("Package could not be found");
            }
            throw new LinuxPackageException("Could not install package");
        }
    }

    @Override
    public void uninstall() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("apt-get", new String[]{"--yes", "--force-yes", "remove", this.linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxPackageException("Could not uninstall package");
        }
    }
}

