/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.IController;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.stream.Collectors;

public abstract class AbstractResource {
    private LinuxCGroup cGroup;
    private IController controller;
    private boolean isActive = false;

    public AbstractResource(LinuxCGroup cGroup, IController controller) {
        this.cGroup = cGroup;
        this.controller = controller;
    }

    protected void create() throws Exception {
        if (this.isActive()) {
            throw new LinuxCGroupException("CGroup has already been created");
        }
        this.setIsActive(true);
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgcreate -g " + this.controller.getName() + ":/" + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not create cgroup");
        }
    }

    public void destroy() throws Exception {
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgdelete " + this.controller.getName() + ":/" + this.cGroup.getName());
        process.waitForExit();
    }

    public void limitProcess(IProcess process) throws Exception {
        if (!this.isActive()) {
            this.create();
        }
        this.classifyProcess(process);
        if (!this.cGroup.hasProcess(process.getId())) {
            this.cGroup.addProcess(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void classifyProcess(final IProcess process) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>(){
                {
                    this.add(process.getId());
                    this.addAll(process.getChildren().stream().map(IProcess::getId).collect(Collectors.toList()));
                }
            };
            childProcess.spawn("cgclassify -g " + this.controller.getName() + ":" + this.cGroup.getName() + " " + Joiner.on(' ').join(ids));
            childProcess.waitForExit();
            if (childProcess.getExitCode() != 0) {
                throw new LinuxCGroupException("Could not classify process");
            }
        }
        finally {
            childProcess.delete();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }
}

