/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupAlreadyExistsException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LinuxCGroups {
    private static List<LinuxCGroup> cGroups = new CopyOnWriteArrayList<LinuxCGroup>();

    public static List<LinuxCGroup> getAll() {
        return cGroups;
    }

    public static LinuxCGroup create(String name) throws Exception {
        if (LinuxCGroups.exists(name)) {
            throw new LinuxCGroupAlreadyExistsException("Linux CGroup " + name + " already exists");
        }
        LinuxCGroup linuxCGroup = new LinuxCGroup(name);
        cGroups.add(linuxCGroup);
        return linuxCGroup;
    }

    public static boolean exists(String name) {
        for (LinuxCGroup linuxCGroup : LinuxCGroups.getAll()) {
            if (!linuxCGroup.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

