/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup;

import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupProcess;
import com.gamedash.daemon.linux.cgroup.LinuxCGroups;
import com.gamedash.daemon.linux.cgroup.resource.CPUResource;
import com.gamedash.daemon.linux.cgroup.resource.DiskResource;
import com.gamedash.daemon.linux.cgroup.resource.IResource;
import com.gamedash.daemon.linux.cgroup.resource.RAMResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxCGroup {
    private static Logger logger = LoggerFactory.getLogger(LinuxCGroup.class);
    private static final int watchdogInterval = 30000;
    private String name;
    private CPUResource cpu;
    private RAMResource ram;
    private DiskResource disk;
    private Thread watchdogThread;
    private List<LinuxCGroupProcess> processes = new CopyOnWriteArrayList<LinuxCGroupProcess>();

    public LinuxCGroup(String name) {
        this.name = name;
        this.cpu = new CPUResource(this);
        this.ram = new RAMResource(this);
        this.disk = new DiskResource(this);
    }

    public String getName() {
        return this.name;
    }

    public CPUResource getCPU() {
        return this.cpu;
    }

    public RAMResource getRAM() {
        return this.ram;
    }

    public DiskResource getDisk() {
        return this.disk;
    }

    public void delete() throws Exception {
        if (this.cpu.isActive()) {
            this.cpu.destroy();
        }
        if (this.ram.isActive()) {
            this.ram.destroy();
        }
        if (this.disk.isActive()) {
            this.disk.destroy();
        }
        if (this.watchdogThreadIsRunning()) {
            this.stopWatchdogThread();
        }
        LinuxCGroups.getAll().remove(this);
    }

    public void startEnforcing() throws Exception {
        this.enforce();
        this.startWatchdogThread();
    }

    public void stopEnforcing() {
        if (this.watchdogThreadIsRunning()) {
            this.stopWatchdogThread();
        }
    }

    public void enforce() throws Exception {
        for (LinuxCGroupProcess process : this.getProcesses()) {
            if (!Processes.exists(process.getId())) {
                this.removeProcess(process.getId());
                continue;
            }
            for (IResource resource : process.getLimitedResources()) {
                resource.limitProcess(process);
            }
        }
    }

    private synchronized void startWatchdogThread() throws Exception {
        if (this.watchdogThreadIsRunning()) {
            throw new LinuxCGroupException("Watchdog thread is already running");
        }
        this.watchdogThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(30000L);
                        this.enforce();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                    continue;
                }
                break;
            }
        });
        this.watchdogThread.start();
    }

    private boolean watchdogThreadIsRunning() {
        return this.watchdogThread != null && this.watchdogThread.isAlive();
    }

    private void stopWatchdogThread() {
        this.watchdogThread.interrupt();
        this.watchdogThread = null;
    }

    public List<LinuxCGroupProcess> getProcesses() {
        return this.processes;
    }

    public void addProcess(IProcess process) {
        this.processes.add(new LinuxCGroupProcess(process));
    }

    public LinuxCGroupProcess getProcess(int id) {
        for (LinuxCGroupProcess process : this.getProcesses()) {
            if (process.getId() != id) continue;
            return process;
        }
        return null;
    }

    public boolean hasProcess(int id) {
        return this.getProcess(id) != null;
    }

    public void removeProcess(int id) {
        for (LinuxCGroupProcess classifiedProcess : this.getProcesses()) {
            if (classifiedProcess.getId() != id) continue;
            this.getProcesses().remove(classifiedProcess);
            break;
        }
    }
}

