/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.fileSystem;

import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUser;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUsers;
import com.google.common.io.Files;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.session.Session;

public class FileSystemProvider
extends RootedFileSystemProvider {
    private Session session;

    public FileSystemProvider(Session session) {
        this.session = session;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        try {
            return super.newDirectoryStream(dir, new Filter(this.session));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static class Filter
    implements DirectoryStream.Filter<Path> {
        private RemoteFileSystemUser remoteUser;

        private Filter(Session session) throws Exception {
            this.remoteUser = RemoteFileSystemUsers.get(session.getUsername());
        }

        @Override
        public boolean accept(Path entry) {
            return !this.remoteUser.getFiles().getExtensions().getBlacklisted().contains(Files.getFileExtension(entry.toString()));
        }
    }
}

