/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.upload.session;

import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class Sessions {
    private static List<Session> sessions = new CopyOnWriteArrayList<Session>();

    public static List<Session> getAll() {
        return sessions;
    }

    public static Session create(File destination, long chunkCount) throws Exception {
        return Sessions.create(UUID.randomUUID(), destination, chunkCount);
    }

    public static Session create(UUID id, File destination, long chunkCount) throws Exception {
        Session session = new Session(id, destination, chunkCount);
        sessions.add(session);
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        return session;
    }

    public static Session get(UUID id) throws Exception {
        for (Session session : Sessions.getAll()) {
            if (!session.getId().equals(id)) continue;
            return session;
        }
        throw new Exception("Could not get session");
    }

    public static boolean exists(UUID id) {
        for (Session session : Sessions.getAll()) {
            if (!session.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

