/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.fileDownloader;

import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderFileNotFoundException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.IFileDownloaderOnProgress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FileDownloader {
    private File file;
    private URL url;
    private List<IFileDownloaderOnProgress> onDownloadProgressCallbacks = new ArrayList<IFileDownloaderOnProgress>();

    public FileDownloader(File file, URL url) {
        this.file = file;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws Exception {
        if (this.file.exists() && this.file.isDirectory()) {
            throw new FileDownloaderException("File is a directory");
        }
        File directory = this.file.getAbsoluteFile().getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        HttpURLConnection connection = this.createHttpConnection(this.url);
        long totalSize = connection.getContentLengthLong();
        int bufferSize = 1024;
        BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            int length;
            byte[] buffer = new byte[bufferSize];
            long downloadedSize = 0L;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                double percentage = (double)(downloadedSize += (long)length) / (double)totalSize * 100.0;
                this.onDownloadProgressCallbacks.forEach(callback -> callback.method(percentage));
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private HttpURLConnection createHttpConnection(URL url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        if (url.getProtocol().equals("https")) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpConnection;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            httpsURLConnection.setSSLSocketFactory(sc.getSocketFactory());
            httpsURLConnection.setHostnameVerifier((hostname, session) -> true);
        }
        httpConnection.connect();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                return this.createHttpConnection(new URL(httpConnection.getHeaderField("Location")));
            }
            if (httpConnection.getResponseCode() == 404) {
                throw new FileDownloaderFileNotFoundException("File not found");
            }
            throw new FileDownloaderException("Server responded with status code " + httpConnection.getResponseCode());
        }
        return httpConnection;
    }

    public void onDownloadProgress(IFileDownloaderOnProgress callback) {
        this.onDownloadProgressCallbacks.add(callback);
    }
}

