/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.File;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import spark.Request;
import spark.Response;

public class Exists
extends Route<Object> {
    public Exists(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<OutputResult> execute() throws Exception {
        List<String> filePaths = this.getParameters().get("files").getList();
        ArrayList<OutputResult> outputResults = new ArrayList<OutputResult>();
        for (String filePath : filePaths) {
            File file = File.fromBase64(filePath);
            outputResults.add(new OutputResult(file, file.exists()));
        }
        return outputResults;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files"};
    }

    private static class OutputResult {
        @SerializedName(value="path")
        private final String path;
        @SerializedName(value="exists")
        private final boolean exists;

        public OutputResult(File file, boolean exists) {
            this.path = file.getPath();
            this.exists = exists;
        }
    }
}

