/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.zeroturnaround.zip.commons.FileUtils;
import spark.Request;
import spark.Response;

public class Copy
extends Route<String> {
    public Copy(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        List<String> filePaths = this.getParameters().get("files").getList();
        File directory = File.fromBase64(this.getParameters().get("directory").getValue());
        if (directory.exists() && !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        for (String filePath : filePaths) {
            File file = File.fromBase64(filePath);
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, new File(directory.getPath() + "/" + file.getName()));
                continue;
            }
            FileUtils.copyFile(file, new File(directory.getPath() + "/" + file.getName()));
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "directory"};
    }
}

