/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.TcpForwardingFilter;

public enum AllowTcpForwardingValue implements TcpForwardingFilter
{
    ALL{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return true;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return true;
        }
    }
    ,
    NONE{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return false;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return false;
        }
    }
    ,
    LOCAL{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return true;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return false;
        }
    }
    ,
    REMOTE{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return false;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return true;
        }
    };

    public static final Set<AllowTcpForwardingValue> VALUES;

    public static AllowTcpForwardingValue fromString(String s2) {
        if (GenericUtils.isEmpty(s2)) {
            return null;
        }
        if ("yes".equalsIgnoreCase(s2)) {
            return ALL;
        }
        if ("no".equalsIgnoreCase(s2)) {
            return NONE;
        }
        for (AllowTcpForwardingValue v : VALUES) {
            if (!s2.equalsIgnoreCase(v.name())) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(AllowTcpForwardingValue.class));
    }
}

