/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.response;

import com.schokkerit.restapi.client.ApiQuery;
import com.schokkerit.restapi.client.ApiQueryException;
import com.schokkerit.restapi.client.response.IQueryResponseErrorHandlerCallback;
import com.schokkerit.restapi.client.response.QueryResponse;
import com.schokkerit.restapi.client.response.QueryResponseErrorHandler;
import java.util.Stack;

public class QueryResponseErrorHandlerManager {
    public ApiQuery query;
    private Stack<QueryResponseErrorHandler> handlers = new Stack();

    public QueryResponseErrorHandlerManager(ApiQuery query) {
        this.query = query;
        this.registerDefault();
    }

    public void registerHandler(IQueryResponseErrorHandlerCallback callback) {
        this.registerHandler(new QueryResponseErrorHandler(callback));
    }

    public void registerHandler(QueryResponseErrorHandler handler) {
        this.handlers.add(handler);
    }

    public void handleIncoming(QueryResponse response) {
        this.handlers.forEach(handler -> handler.execute(response));
    }

    private void registerDefault() {
        this.registerHandler(new QueryResponseErrorHandler(response -> {
            throw new ApiQueryException("Query returned " + response.getStatusCode());
        }));
    }
}

