/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.process;

import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.windows.process.WindowsBridgeProcessPriorityEnum;
import com.gamedash.daemon.windows.process.WindowsBridgeProcesses;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsBridgeProcess {
    private int id;

    public WindowsBridgeProcess(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessName(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsString();
    }

    public String getFileName() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessFileName(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsString();
    }

    public String[] getArguments() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessArguments(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsString().split("\\\\s+");
    }

    public File getWorkingDirectory() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessWorkingDirectory(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return new File(result.getResultValueAsString());
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killProcess(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
    }

    public List<WindowsBridgeProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessChildren(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsBridgeProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public WindowsBridgeProcessPriorityEnum getPriority() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessPriority(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        int integer = result.getResultValueAsInteger();
        for (WindowsBridgeProcessPriorityEnum priority : WindowsBridgeProcessPriorityEnum.values()) {
            if (priority.getInteger() != integer) continue;
            return priority;
        }
        return null;
    }

    public void setPriority(WindowsBridgeProcessPriorityEnum priority) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessPriority(this.getId(), priority.getInteger()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
    }
}

