/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.host;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.relay.host.Host;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class Hosts {
    private static List<Host> allHosts;

    public static List<Host> getAll() throws Exception {
        if (allHosts == null) {
            ApiQuery query = ApiClient.createQuery("infrastructure/relay/host/all");
            ArrayList<Host> hosts = new ArrayList<Host>();
            for (JsonElement jsonElement : query.get().getJsonObject().get("response").getAsJsonArray()) {
                Host host = new Host(jsonElement.getAsJsonObject().get("id").getAsString());
                host.setIsPrimary(jsonElement.getAsJsonObject().get("isPrimary").getAsBoolean());
                JsonObject networkJsonObject = jsonElement.getAsJsonObject().get("network").getAsJsonObject();
                host.getNetwork().setDomain(networkJsonObject.get("domain").getAsString());
                host.getNetwork().setSocketPort(networkJsonObject.getAsJsonObject().get("socket").getAsJsonObject().get("port").getAsInt());
                host.getNetwork().setApiPort(networkJsonObject.getAsJsonObject().get("api").getAsJsonObject().get("port").getAsInt());
                host.getNetwork().setApiIsSecure(networkJsonObject.getAsJsonObject().get("api").getAsJsonObject().get("isSecure").getAsBoolean());
                hosts.add(host);
            }
            allHosts = hosts;
        }
        return allHosts;
    }

    public static Host getPrimary() throws Exception {
        for (Host host : Hosts.getAll()) {
            if (!host.isPrimary()) continue;
            return host;
        }
        return null;
    }

    public static boolean hasCurrent() throws Exception {
        return Hosts.getAll().size() > 0;
    }
}

