/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.linux;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.ProcessPriorityEnum;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.platform.Common;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendant;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendants;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class LinuxProcess
implements IProcess {
    private final int id;
    private final LinuxProcessDescendants descendants;
    private ProcessPriorityEnum priority = ProcessPriorityEnum.normal;

    public LinuxProcess(int id) {
        this.id = id;
        this.descendants = new LinuxProcessDescendants(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() throws Exception {
        return this.readProcStatusFile().get("Name");
    }

    @Override
    public String[] getCommandLine() throws Exception {
        try {
            return FileUtils.readFileToString(new File("/proc/" + this.getId() + "/cmdline"), StandardCharsets.UTF_8).split("\u0000");
        }
        catch (FileNotFoundException e) {
            throw new ProcessNotFoundException(this.getId());
        }
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return Files.readSymbolicLink(Paths.get("/proc/" + this.getId() + "/cwd", new String[0])).toFile();
    }

    @Override
    public void kill() throws Exception {
        this.kill("SIGKILL");
    }

    @Override
    public void kill(String signal) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        childProcess.setUseShell(false);
        childProcess.spawn("kill", new String[]{"-" + signal, Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public void stop() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        childProcess.spawn("kill", new String[]{"-s", "TERM", Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public ProcessPriorityEnum getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ProcessPriorityEnum priority) {
        this.priority = priority;
    }

    @Override
    public List<IProcess> getAllChildren() throws Exception {
        ArrayList<IProcess> children = new ArrayList<IProcess>();
        for (LinuxProcessDescendant descendant : LinuxProcessDescendants.find(this)) {
            children.add(descendant.getProcess());
        }
        return children;
    }

    public List<IProcess> getChildren() throws Exception {
        ArrayList<IProcess> children = new ArrayList<IProcess>();
        for (LinuxProcessDescendant descendant : this.descendants.getImmediate().getAll()) {
            children.add(descendant.getProcess());
        }
        return children;
    }

    public List<LinuxProcess> getThreads() throws Exception {
        try {
            ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
            File tasksDirectory = new File("/proc/" + this.getId() + "/task");
            if (!tasksDirectory.exists()) {
                throw new ProcessNotFoundException(this.getId());
            }
            File[] files = tasksDirectory.listFiles();
            if (files == null) {
                return processes;
            }
            for (File file : files) {
                if (!file.isDirectory()) continue;
                processes.add((LinuxProcess)Processes.get(Integer.parseInt(file.getName())));
            }
            return processes;
        }
        catch (FileNotFoundException exception) {
            throw new ProcessNotFoundException(this.getId());
        }
    }

    public Map<String, String> readProcStatusFile() throws Exception {
        try {
            List<String> lines = FileUtils.readLines(new File("/proc/" + this.getId() + "/status"), StandardCharsets.UTF_8);
            HashMap<String, String> output = new HashMap<String, String>();
            for (String line : lines) {
                String[] lineBits = line.split(":", 2);
                output.put(lineBits[0], lineBits[1].split("\\s+", 2)[1]);
            }
            return output;
        }
        catch (FileNotFoundException exception) {
            throw new ProcessNotFoundException(this.getId());
        }
    }

    @Override
    public boolean isSelf() {
        return Common.processIsSelf(this);
    }

    public boolean equals(Object process) {
        return process instanceof IProcess && ((IProcess)process).getId() == this.getId();
    }
}

