/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.resource.limit.api;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroups;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.api.IResourceLimitApi;
import org.apache.commons.lang3.RandomStringUtils;

public class LinuxResourceLimitApi
implements IResourceLimitApi {
    private ChildProcess childProcess;
    private LinuxCGroup cGroup;

    public LinuxResourceLimitApi(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    @Override
    public void setCPU(CPUResourceLimit cpu) throws Exception {
        LinuxCGroup cGroup = this.getCGroup();
        cGroup.getCPU().setPercentage(cpu.getPercentage() != null ? cpu.getPercentage().intValue() : cpu.getPercentageFromThreads());
        cGroup.getCPU().limitProcess(this.childProcess.getProcess());
    }

    @Override
    public void setRAM(RAMResourceLimit ram) throws Exception {
        LinuxCGroup cGroup = this.getCGroup();
        cGroup.getRAM().setMB(ram.getMB());
        cGroup.getCPU().limitProcess(this.childProcess.getProcess());
    }

    @Override
    public void setDisk(DiskResourceLimit disk) throws Exception {
        LinuxCGroup cGroup = this.getCGroup();
        cGroup.getDisk().setMBs(disk.getMBs());
        cGroup.getCPU().limitProcess(this.childProcess.getProcess());
    }

    private LinuxCGroup getCGroup() throws Exception {
        if (this.cGroup == null) {
            this.cGroup = LinuxCGroups.create(RandomStringUtils.randomAlphanumeric(24));
        }
        return this.cGroup;
    }
}

