/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource.disk;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.DiskController;
import com.gamedash.daemon.linux.cgroup.resource.Common;
import com.gamedash.daemon.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class DiskResource
extends Common
implements IResource {
    private LinuxCGroup cGroup;
    private int mbs;

    public DiskResource(LinuxCGroup cGroup) {
        super(cGroup, new DiskController());
        this.cGroup = cGroup;
    }

    public int getMBs() {
        return this.mbs;
    }

    public void setMBs(int mbs) throws Exception {
        if (!this.isActive()) {
            this.create();
        }
        this.mbs = mbs;
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r blkio.throttle.read_bps_device=\"252:0 " + mbs + "\" " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set disk throttle");
        }
    }

    @Override
    public void limitProcess(IProcess process) throws Exception {
        this.classifyProcess(process);
    }
}

