/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.installer.userInterface;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.fileSystem.file.File;
import com.gamedash.daemon.installer.userInterface.UserInterfaceQuestionsResult;
import com.gamedash.daemon.installer.userInterface.YesNoEnum;
import java.util.ArrayList;
import org.apache.commons.validator.routines.DomainValidator;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;

public class UserInterface {
    public UserInterfaceQuestionsResult askQuestions() {
        TextIO textIO = TextIoFactory.getTextIO();
        final UserInterfaceQuestionsResult result = new UserInterfaceQuestionsResult();
        if (Application.args.installerApiDomain == null) {
            result.apiClientDomain = (String)((StringInputReader)textIO.newStringInputReader().withValueChecker((value, itemName) -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                if (!DomainValidator.getInstance().isValid((String)value)) {
                    errorMessages.add("Invalid domain");
                }
                return errorMessages;
            })).read("API domain");
        }
        if (Application.args.installerAuthenticationToken == null) {
            result.authenticationToken = new AuthenticationToken((String)((StringInputReader)textIO.newStringInputReader().withValueChecker((token, itemName) -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                try {
                    ApiQuery query = new ApiQuery("infrastructure/node/daemon/authentication/token/isvalid"){

                        @Override
                        protected String getAddress() throws Exception {
                            return this.getProtocol() + "://" + result.apiClientDomain + "/v1/" + this.getEndpoint();
                        }
                    };
                    query.getParameters().create("token", (String)token);
                    if (!query.get().getJsonObject().get("response").getAsBoolean()) {
                        errorMessages.add("Token is invalid");
                    }
                }
                catch (Exception e) {
                    errorMessages.add(e.getMessage());
                }
                return errorMessages;
            })).read("Authentication token"));
        }
        if (Application.args.installerKeyStoreFile == null && Application.args.installerKeyStorePassword == null) {
            File keyStoreFile = new File((String)((StringInputReader)textIO.newStringInputReader().withValueChecker((value, itemName) -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                File file = new File((String)value);
                if (!file.exists() || file.isDirectory()) {
                    errorMessages.add("Key store does not exist");
                } else if (file.getExtension() == null || !file.getExtension().equals("jks")) {
                    errorMessages.add("Key store must be jks");
                }
                return errorMessages;
            })).read("Key store location"));
            result.security.keyStoreFile = keyStoreFile;
            result.security.keyStorePassword = (String)((StringInputReader)((StringInputReader)textIO.newStringInputReader().withInputMasking(true)).withValueChecker((value, itemName) -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                try {
                    if (!KeyStore.validatePassword(keyStoreFile, value)) {
                        errorMessages.add("Invalid key store password");
                    }
                }
                catch (Exception e) {
                    errorMessages.add(e.getMessage());
                }
                return errorMessages;
            })).read("Key store password");
        }
        if (Application.args.installerKeyStoreIsSelfSigned == null) {
            YesNoEnum keyStoreIsSelfSigned = (YesNoEnum)((Object)textIO.newEnumInputReader(YesNoEnum.class).read("Is the key store self-signed?"));
            result.security.keyStoreIsSelfSigned = keyStoreIsSelfSigned == YesNoEnum.yes;
        }
        return result;
    }
}

