/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host;

import com.gamedash.daemon.fileSystem.remote.host.implementation.IRemoteFileSystemHostImplementation;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUserSession;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.List;

public class RemoteFileSystemHost {
    private Class<?> implementationClass;
    private IRemoteFileSystemHostImplementation implementationInstance;
    private InetAddress ipAddress;
    private int port;
    private boolean isSecure;

    public RemoteFileSystemHost(Class<?> implementationClass, InetAddress ipAddress, int port, boolean isSecure) {
        this.implementationClass = implementationClass;
        this.ipAddress = ipAddress;
        this.port = port;
        this.isSecure = isSecure;
    }

    public void start() throws Exception {
        this.getImplementationInstance().start();
    }

    public void stop() throws Exception {
        this.getImplementationInstance().stop();
    }

    public boolean isRunning() throws Exception {
        return this.getImplementationInstance().isRunning();
    }

    public List<RemoteFileSystemUserSession> getSessions() throws Exception {
        return this.getImplementationInstance().getSessions();
    }

    public void disconnectSession(RemoteFileSystemUserSession session) throws Exception {
        this.getImplementationInstance().disconnectSession(session);
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private IRemoteFileSystemHostImplementation getImplementationInstance() throws Exception {
        if (this.implementationInstance == null) {
            Constructor<?> constructor = this.implementationClass.getConstructor(new Class[0]);
            IRemoteFileSystemHostImplementation implementation = (IRemoteFileSystemHostImplementation)constructor.newInstance(new Object[0]);
            implementation.setPort(this.getPort());
            this.implementationInstance = implementation;
        }
        return this.implementationInstance;
    }
}

