/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.registered;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.QueryResponse;
import com.gamedash.daemon.fileSystem.file.registered.RequiredFile;
import com.gamedash.daemon.fileSystem.file.registered.RequiredFileAlreadyExistsException;
import java.io.File;

public class RequiredFiles {
    public static RequiredFile create(String name, File file, boolean isDirectory) throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/file/registered");
        query.getParameters().create("name", name);
        query.getParameters().create("path", file.getPath());
        query.getParameters().create("isDirectory", isDirectory);
        query.setShouldHandleResponse(false);
        QueryResponse response = query.post();
        if (response.getStatusCode() != 200) {
            if (response.getStatusCode() == 409) {
                throw new RequiredFileAlreadyExistsException("File already exists");
            }
            throw new Exception(response.getJsonObject().get("error").getAsJsonObject().get("status").getAsString());
        }
        return RequiredFiles.get(name);
    }

    public static RequiredFile get(String name) {
        return new RequiredFile(name);
    }
}

