/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="ProcessUsage")
public class ProcessUsageDependency
implements IDependency {
    @Override
    public void install() throws Exception {
        URL url = SystemUtils.IS_OS_WINDOWS ? new URL("https://download.gamedash.io/daemon/dependency/versions/1/ProcessUsage-Windows.exe") : new URL("https://download.gamedash.io/daemon/dependency/versions/1/ProcessUsage-Linux");
        FileDownloader fileDownloader = new FileDownloader(ProcessUsageDependency.getFile(), url);
        fileDownloader.download();
        ProcessUsageDependency.getFile().setExecutable(true);
    }

    @Override
    public void uninstall() {
        ProcessUsageDependency.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static File getFile() {
        String fileName = SystemUtils.IS_OS_WINDOWS ? "ProcessUsage-Windows.exe" : "ProcessUsage-Linux";
        return new File(FileSystem.getRootDirectory().getPath() + File.separator + fileName);
    }
}

