/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.linux.Linux;
import com.gamedash.daemon.linux.LinuxDistroEnum;
import com.gamedash.daemon.linux.LinuxRelease;
import com.gamedash.daemon.linux.packages.LinuxPackages;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="LinuxCGroups")
public class LinuxCGroupDependency
implements IDependency {
    @Override
    public void install() throws Exception {
        LinuxRelease linuxDistro = Linux.getRelease();
        if (linuxDistro.getDistro() == LinuxDistroEnum.centos || linuxDistro.getDistro() == LinuxDistroEnum.rhel) {
            LinuxPackages.get("libcgroup").install();
        } else if (linuxDistro.getDistro() == LinuxDistroEnum.ubuntu || linuxDistro.getDistro() == LinuxDistroEnum.debian) {
            LinuxPackages.get("cgroup-tools").install();
        }
    }

    @Override
    public void uninstall() throws Exception {
        LinuxRelease linuxDistro = Linux.getRelease();
        if (linuxDistro.getDistro() == LinuxDistroEnum.centos || linuxDistro.getDistro() == LinuxDistroEnum.rhel) {
            LinuxPackages.get("libcgroup").uninstall();
        } else if (linuxDistro.getDistro() == LinuxDistroEnum.ubuntu || linuxDistro.getDistro() == LinuxDistroEnum.debian) {
            LinuxPackages.get("cgroup-tools").uninstall();
        }
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_LINUX;
    }
}

