/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.dependency.LinuxCGroupDependency;
import com.gamedash.daemon.dependency.ProcessUsageDependency;
import com.gamedash.daemon.dependency.WindowsBridgeDependency32;
import com.gamedash.daemon.dependency.WindowsBridgeDependency64;
import com.gamedash.daemon.dependency.WindowsChocolateyDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependencies {
    private static List<Dependency> dependencies;
    private static Logger logger;

    public static List<Dependency> getAll() {
        if (dependencies == null) {
            ArrayList<Class<WindowsChocolateyDependency>> dependencyClasses = new ArrayList<Class<WindowsChocolateyDependency>>();
            dependencyClasses.add(LinuxCGroupDependency.class);
            dependencyClasses.add(WindowsBridgeDependency32.class);
            dependencyClasses.add(WindowsBridgeDependency64.class);
            dependencyClasses.add(ProcessUsageDependency.class);
            dependencyClasses.add(WindowsChocolateyDependency.class);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            for (Class clazz : dependencyClasses) {
                dependencies.add(new Dependency(clazz));
            }
            Dependencies.dependencies = dependencies;
        }
        return dependencies;
    }

    public static Dependency get(String name) {
        for (Dependency dependency : Dependencies.getAll()) {
            if (!dependency.getName().equals(name)) continue;
            return dependency;
        }
        return null;
    }

    public static void install() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (Dependency dependency : Dependencies.getAll()) {
            if (dependency.isInstalled() || !dependency.isAvailable()) continue;
            threads.add(new Thread(() -> {
                try {
                    dependency.install();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }));
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    public static List<Dependency> getInstalled() throws Exception {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (Config.getFile("daemon.properties").valueExists("dependencies")) {
            for (String name : Config.getFile("daemon.properties").getValueAsList("dependencies")) {
                Dependency dependency = Dependencies.get(name);
                if (dependency == null) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    public static synchronized void addInstalled(Dependency dependency) throws Exception {
        List<Dependency> dependencies = Dependencies.getInstalled();
        dependencies.add(dependency);
        Dependencies.setInstalled(dependencies);
    }

    public static void removeInstalled(Dependency dependency) throws Exception {
        List<Dependency> dependencies = Dependencies.getInstalled().stream().filter(_dependency -> _dependency.getName().equals(dependency.getName())).collect(Collectors.toList());
        Dependencies.setInstalled(dependencies);
    }

    private static void setInstalled(List<Dependency> dependencies) throws Exception {
        List versionIds = dependencies.stream().map(Dependency::getName).collect(Collectors.toList());
        Config.getFile("daemon.properties").setValue("dependencies", versionIds);
    }

    static {
        logger = LoggerFactory.getLogger(Dependencies.class);
    }
}

