/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.config;

import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.config.ConfigFile;
import com.gamedash.daemon.common.config.ConfigFileNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class Config {
    private static List<ConfigFile> files = new ArrayList<ConfigFile>();
    private static ConfigFile defaultFile = new ConfigFile(new File("default.properties"));

    public static ConfigFile getDefaultFile() {
        return defaultFile;
    }

    public static void setDefaultFile(ConfigFile file) {
        if (!file.toFile().exists()) {
            throw new ConfigFileNotFoundException("Can not set config file to " + file.toFile().getPath() + " as default because it does not exist");
        }
        defaultFile = file;
    }

    public static List<ConfigFile> getFiles() {
        return files;
    }

    public static void reloadFiles() {
        for (ConfigFile file : Config.getFiles()) {
            file.reload();
        }
    }

    public static ConfigFile getFile(String path) throws IOException {
        ConfigFile configFile2;
        for (ConfigFile configFile2 : files) {
            if (!configFile2.getFile().toPath().equals(Paths.get(path, new String[0]))) continue;
            return configFile2;
        }
        File file = new File(path);
        if (!file.exists()) {
            Config.createFile(path);
        }
        configFile2 = new ConfigFile(file);
        files.add(configFile2);
        return configFile2;
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static void createFile(String path) throws IOException, ConfigException {
        File file = new File(path);
        if (file.exists()) {
            throw new IOException("File " + path + " already exists");
        }
        file.createNewFile();
    }
}

