/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess.resource;

import com.gamedash.daemon.api.server.parameter.ParameterException;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.process.ProcessPriorityEnum;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.ResourceLimits;
import spark.Request;
import spark.Response;

public class LimitResources
extends Route<String> {
    public LimitResources(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        DiskResourceLimit diskResourceLimit;
        RAMResourceLimit ramResourceLimit;
        int id = this.getParameters().get("id").getValue(Integer.class);
        if (!ChildProcesses.exists(id)) {
            throw new ChildProcessNotFoundException(id);
        }
        ChildProcess childProcess = ChildProcesses.get(id);
        ResourceLimits resourceLimits = childProcess.getResourceLimits();
        CPUResourceLimit cpuResourceLimit = this.getCPUResourceLimit();
        if (cpuResourceLimit != null) {
            resourceLimits.setCPU(cpuResourceLimit);
        }
        if ((ramResourceLimit = this.getRAMResourceLimit()) != null) {
            resourceLimits.setRAM(ramResourceLimit);
        }
        if ((diskResourceLimit = this.getDiskResourceLimit()) != null) {
            resourceLimits.setDisk(diskResourceLimit);
        }
        return null;
    }

    private CPUResourceLimit getCPUResourceLimit() throws Exception {
        CPUResourceLimit cpu = new CPUResourceLimit();
        if (this.getParameters().exists("cpuPercentage")) {
            cpu.setPercentage(this.getParameters().get("cpuPercentage").getValue(Integer.class));
        } else if (this.getParameters().exists("cpuThreads")) {
            cpu.setThreads(this.getParameters().get("cpuThreads").getValue(Integer.class));
        }
        ProcessPriorityEnum processPriority = this.getCPUResourceLimitPriority();
        if (processPriority != null) {
            cpu.setPriority(processPriority);
        }
        return cpu;
    }

    private ProcessPriorityEnum getCPUResourceLimitPriority() throws Exception {
        if (this.getParameters().exists("cpuPriority")) {
            for (ProcessPriorityEnum priority : ProcessPriorityEnum.values()) {
                if (!priority.getName().equals(this.getParameters().get("cpuPriority").getValue(String.class))) continue;
                return priority;
            }
        }
        return null;
    }

    private RAMResourceLimit getRAMResourceLimit() throws ParameterException {
        if (!this.getParameters().exists("ramMB")) {
            return null;
        }
        RAMResourceLimit ram = new RAMResourceLimit();
        ram.setMB(this.getParameters().get("ramMB").getValue(Integer.class));
        return ram;
    }

    private DiskResourceLimit getDiskResourceLimit() throws ParameterException {
        if (!this.getParameters().exists("ramMBs")) {
            return null;
        }
        DiskResourceLimit disk = new DiskResourceLimit();
        disk.setMBs(this.getParameters().get("ramMBs").getValue(Integer.class));
        return disk;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }
}

