/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.ApiServerException;
import com.gamedash.daemon.api.server.ErrorBody;
import com.google.gson.Gson;

public class ExceptionHandler<T extends Exception> {
    private Class<T> type;
    private int code = 400;
    private Gson gson = new Gson();
    private ApiServer server;

    public ExceptionHandler(Class<T> type) {
        this.type = type;
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int code) {
        this.server = server;
        this.type = type;
        this.code = code;
    }

    public void register() {
        this.server.getService().exception(this.type, (exception, request, response) -> {
            response.status(this.getCode());
            response.type("application/json");
            ErrorBody errorBody = new ErrorBody(exception.getMessage(), exception.getStackTrace());
            if (exception instanceof ApiServerException && ((ApiServerException)exception).hasCode()) {
                errorBody.setCode(((ApiServerException)exception).getCode());
            }
            response.body(this.gson.toJson(errorBody));
        });
    }

    public int getCode() {
        return this.code;
    }
}

