/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolver;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.ForwardingFilter;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.ReservedSessionMessagesHandlerAdapter;
import org.apache.sshd.common.session.helpers.TimeoutIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Invoker;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public abstract class SessionHelper
extends AbstractKexFactoryManager
implements Session {
    protected final Object sessionLock = new Object();
    protected long authNanoStart = System.nanoTime();
    protected long idleNanoStart = System.nanoTime();
    private final boolean serverSession;
    private final IoSession ioSession;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    private long authTimeoutStart = System.currentTimeMillis();
    private long idleTimeoutStart = System.currentTimeMillis();
    private final AtomicReference<TimeoutIndicator> timeoutStatus = new AtomicReference<TimeoutIndicator>(TimeoutIndicator.NONE);
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private ChannelStreamPacketWriterResolver channelStreamPacketWriterResolver;
    private volatile String username;
    private volatile boolean authed;

    protected SessionHelper(boolean serverSession, FactoryManager factoryManager, IoSession ioSession) {
        super(Objects.requireNonNull(factoryManager, "No factory manager provided"));
        this.serverSession = serverSession;
        this.ioSession = Objects.requireNonNull(ioSession, "No IoSession provided");
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public boolean isServerSession() {
        return this.serverSession;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return (FactoryManager)this.getDelegate();
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getFactoryManager();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    @Override
    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    @Override
    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public void setAuthenticated() throws IOException {
        this.authed = true;
        this.signalSessionEvent(SessionListener.Event.Authenticated);
    }

    protected TimeoutIndicator checkForTimeouts() throws IOException {
        boolean resetTimeout;
        TimeoutIndicator.TimeoutStatus status;
        TimeoutIndicator result;
        block15: {
            long nanoTime;
            if (!this.isOpen() || this.isClosing() || this.isClosed()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("checkForTimeouts({}) session closing", (Object)this);
                }
                return TimeoutIndicator.NONE;
            }
            result = this.timeoutStatus.get();
            TimeoutIndicator.TimeoutStatus timeoutStatus = status = result == null ? TimeoutIndicator.TimeoutStatus.NoTimeout : result.getStatus();
            if (status != null && status != TimeoutIndicator.TimeoutStatus.NoTimeout) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("checkForTimeouts({}) already detected {}", (Object)this, (Object)result);
                }
                return result;
            }
            long now = System.currentTimeMillis();
            result = this.checkAuthenticationTimeout(now, nanoTime = System.nanoTime(), this.getAuthTimeout());
            if (result == null) {
                result = this.checkIdleTimeout(now, nanoTime, this.getIdleTimeout());
            }
            TimeoutIndicator.TimeoutStatus timeoutStatus2 = status = result == null ? TimeoutIndicator.TimeoutStatus.NoTimeout : result.getStatus();
            if (status == null || TimeoutIndicator.TimeoutStatus.NoTimeout.equals((Object)status)) {
                return TimeoutIndicator.NONE;
            }
            resetTimeout = false;
            try {
                SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
                resetTimeout = handler != null && handler.handleTimeoutDisconnectReason(this, result);
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("checkForTimeouts({}) failed ({}) to invoke disconnect handler to handle {}: {}", this, e.getClass().getSimpleName(), result, e.getMessage());
                if (!this.log.isDebugEnabled()) break block15;
                this.log.debug("checkForTimeouts(" + this + ") disconnect handler exception details", e);
            }
        }
        if (resetTimeout) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkForTimeouts({}) cancel {} due to handler intervention", (Object)this, (Object)result);
            }
            switch (status) {
                case AuthTimeout: {
                    this.resetAuthTimeout();
                    break;
                }
                case IdleTimeout: {
                    this.resetIdleTimeout();
                    break;
                }
            }
            return TimeoutIndicator.NONE;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkForTimeouts({}) disconnect - reason={}", (Object)this, (Object)result);
        }
        this.timeoutStatus.set(result);
        this.disconnect(2, "Detected " + (Object)((Object)status) + " after " + result.getExpiredValue() + "/" + result.getThresholdValue() + " ms.");
        return result;
    }

    @Override
    public long getAuthTimeoutStart() {
        return this.authTimeoutStart;
    }

    @Override
    public long resetAuthTimeout() {
        long value = this.getAuthTimeoutStart();
        this.authTimeoutStart = System.currentTimeMillis();
        this.authNanoStart = System.nanoTime();
        return value;
    }

    protected TimeoutIndicator checkAuthenticationTimeout(long now, long nanoTime, long authTimeoutMs) {
        long authDiffNano = nanoTime - this.authNanoStart;
        long authDiffMs = TimeUnit.NANOSECONDS.toMillis(authDiffNano);
        if (!this.isAuthenticated() && authTimeoutMs > 0L && authDiffMs > authTimeoutMs) {
            return new TimeoutIndicator(TimeoutIndicator.TimeoutStatus.AuthTimeout, authTimeoutMs, authDiffMs);
        }
        return null;
    }

    @Override
    public long getIdleTimeoutStart() {
        return this.idleTimeoutStart;
    }

    protected TimeoutIndicator checkIdleTimeout(long now, long nanoTime, long idleTimeoutMs) {
        long idleDiffNano = nanoTime - this.idleNanoStart;
        long idleDiffMs = TimeUnit.NANOSECONDS.toMillis(idleDiffNano);
        if (idleTimeoutMs > 0L && idleDiffMs > idleTimeoutMs) {
            return new TimeoutIndicator(TimeoutIndicator.TimeoutStatus.IdleTimeout, idleTimeoutMs, idleDiffMs);
        }
        return null;
    }

    @Override
    public long resetIdleTimeout() {
        long value = this.getIdleTimeoutStart();
        this.idleTimeoutStart = System.currentTimeMillis();
        this.idleNanoStart = System.nanoTime();
        return value;
    }

    @Override
    public TimeoutIndicator getTimeoutStatus() {
        return this.timeoutStatus.get();
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.resolveEffectiveProvider(ReservedSessionMessagesHandler.class, this.reservedSessionMessagesHandler, this.getFactoryManager().getReservedSessionMessagesHandler());
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler handler) {
        this.reservedSessionMessagesHandler = handler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return this.resolveEffectiveProvider(SessionDisconnectHandler.class, this.sessionDisconnectHandler, this.getFactoryManager().getSessionDisconnectHandler());
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    protected void handleIgnore(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(byte[].class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleIgnore({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleIgnoreMessage(this, buffer);
    }

    protected IoWriteFuture sendNotImplemented(long seqNoValue) throws IOException {
        Buffer buffer = this.createBuffer((byte)3, 8);
        buffer.putInt(seqNoValue);
        return this.writePacket(buffer);
    }

    protected void handleUnimplemented(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Integer.TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleUnimplemented({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleUnimplementedMessage(this, 3, buffer);
    }

    @Override
    public IoWriteFuture sendDebugMessage(boolean display, Object msg, String lang) throws IOException {
        String text = Objects.toString(msg, "");
        lang = lang == null ? "" : lang;
        Buffer buffer = this.createBuffer((byte)4, text.length() + lang.length() + 32);
        buffer.putBoolean(display);
        buffer.putString(text);
        buffer.putString(lang);
        return this.writePacket(buffer);
    }

    protected void handleDebug(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Boolean.TYPE, String.class, String.class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleDebug({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleDebugMessage(this, buffer);
    }

    protected ReservedSessionMessagesHandler resolveReservedSessionMessagesHandler() {
        ReservedSessionMessagesHandler handler = this.getReservedSessionMessagesHandler();
        return handler == null ? ReservedSessionMessagesHandlerAdapter.DEFAULT : handler;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler handler = this.getUnknownChannelReferenceHandler();
        if (handler != null) {
            return handler;
        }
        FactoryManager mgr = this.getFactoryManager();
        return mgr == null ? null : mgr.resolveUnknownChannelReferenceHandler();
    }

    @Override
    public ChannelStreamPacketWriterResolver getChannelStreamPacketWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamPacketWriterResolver(ChannelStreamPacketWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
    }

    @Override
    public ChannelStreamPacketWriterResolver resolveChannelStreamPacketWriterResolver() {
        ChannelStreamPacketWriterResolver resolver = this.getChannelStreamPacketWriterResolver();
        if (resolver != null) {
            return resolver;
        }
        FactoryManager manager = this.getFactoryManager();
        return manager.resolveChannelStreamPacketWriterResolver();
    }

    @Override
    public IoWriteFuture sendIgnoreMessage(byte ... data) throws IOException {
        data = data == null ? GenericUtils.EMPTY_BYTE_ARRAY : data;
        Buffer buffer = this.createBuffer((byte)2, data.length + 8);
        buffer.putBytes(data);
        return this.writePacket(buffer);
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture = this.writePacket(buffer);
        DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        FactoryManager factoryManager = this.getFactoryManager();
        ScheduledExecutorService executor = factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> sched = executor.schedule(() -> {
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            future.setValue(t);
        }, timeout, unit);
        future.addListener(f -> sched.cancel(false));
        return writeFuture;
    }

    protected void signalSessionEstablished(IoSession ioSession) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionEstablished((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to announce session={} established: {}", e.getClass().getSimpleName(), ioSession, e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Session=" + ioSession + " establish failure details", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalSessionEstablished(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionEstablished(this);
    }

    protected void signalSessionCreated(IoSession ioSession) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionCreated((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to announce session={} created: {}", e.getClass().getSimpleName(), ioSession, e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Session=" + ioSession + " creation failure details", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalSessionCreated(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionCreated(this);
    }

    protected void signalPeerIdentificationReceived(String version, List<String> extraLines) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalPeerIdentificationReceived((SessionListener)l, version, extraLines);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("signalPeerIdentificationReceived({}) Failed ({}) to announce peer={}: {}", this, e.getClass().getSimpleName(), version, e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("signalPeerIdentificationReceived(" + this + ")[" + version + "] failure details", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalPeerIdentificationReceived(SessionListener listener, String version, List<String> extraLines) {
        if (listener == null) {
            return;
        }
        listener.sessionPeerIdentificationReceived(this, version, extraLines);
    }

    protected void signalSessionEvent(SessionListener.Event event) throws IOException {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionEvent((SessionListener)l, event);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable t = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendSessionEvent({})[{}] failed ({}) to inform listeners: {}", new Object[]{this, event, t.getClass().getSimpleName(), t.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendSessionEvent(" + this + ")[" + (Object)((Object)event) + "] listener inform details", t);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to send session event: " + t.getMessage(), t);
        }
    }

    protected void signalSessionEvent(SessionListener listener, SessionListener.Event event) throws IOException {
        if (listener == null) {
            return;
        }
        listener.sessionEvent(this, event);
    }

    protected void invokeSessionSignaller(Invoker<SessionListener, Void> invoker) throws Throwable {
        FactoryManager manager = this.getFactoryManager();
        SessionListener[] listeners = new SessionListener[]{manager == null ? null : manager.getSessionListenerProxy(), this.getSessionListenerProxy()};
        Throwable err = null;
        for (SessionListener l : listeners) {
            if (l == null) continue;
            try {
                invoker.invoke(l);
            }
            catch (Throwable t) {
                err = GenericUtils.accumulateException(err, t);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected byte[] resizeKey(byte[] e, int kdfSize, Digest hash, byte[] k, byte[] h2) throws Exception {
        Buffer buffer = null;
        while (kdfSize > e.length) {
            if (buffer == null) {
                buffer = new ByteArrayBuffer();
            }
            buffer.putMPInt(k);
            buffer.putRawBytes(h2);
            buffer.putRawBytes(e);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[e.length + foo.length];
            System.arraycopy(e, 0, bar, 0, e.length);
            System.arraycopy(foo, 0, bar, e.length, foo.length);
            e = bar;
            buffer = BufferUtils.clear(buffer);
        }
        return e;
    }

    protected SocketAddress resolvePeerAddress(SocketAddress knownAddress) {
        if (knownAddress != null) {
            return knownAddress;
        }
        IoSession s2 = this.getIoSession();
        return s2 == null ? null : s2.getRemoteAddress();
    }

    protected long calculateNextIgnorePacketCount(Random r, long freq, int variance) {
        long count;
        if (freq <= 0L || variance < 0) {
            return -1L;
        }
        if (variance == 0) {
            return freq;
        }
        int extra = r.random(variance < 0 ? 0 - variance : variance);
        long l = count = variance < 0 ? freq - (long)extra : freq + (long)extra;
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateNextIgnorePacketCount({}) count={}", (Object)this, (Object)count);
        }
        return count;
    }

    protected String resolveIdentificationString(String configPropName) {
        FactoryManager manager = this.getFactoryManager();
        String ident = manager.getString(configPropName);
        return "SSH-2.0-" + (GenericUtils.isEmpty(ident) ? manager.getVersion() : ident);
    }

    protected IoWriteFuture sendIdentification(String ident) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}): {}", (Object)this, (Object)ident.replace('\r', '|').replace('\n', '|'));
        }
        IoSession networkSession = this.getIoSession();
        byte[] data = (ident + "\r\n").getBytes(StandardCharsets.UTF_8);
        return networkSession.writePacket(new ByteArrayBuffer(data));
    }

    protected List<String> doReadIdentification(Buffer buffer, boolean server) throws IOException {
        int maxIdentSize = PropertyResolverUtils.getIntProperty(this, "max-identification-size", 16384);
        ArrayList<String> ident = null;
        int rpos = buffer.rpos();
        boolean debugEnabled = this.log.isDebugEnabled();
        byte[] data = new byte[256];
        do {
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 0) {
                    throw new StreamCorruptedException("Incorrect identification (null characters not allowed) -  at line " + (GenericUtils.size(ident) + 1) + " character #" + (pos + 1) + " after '" + new String(data, 0, pos, StandardCharsets.UTF_8) + "'");
                }
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new StreamCorruptedException("Incorrect identification (bad line ending)  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                if (pos >= data.length) {
                    throw new StreamCorruptedException("Incorrect identification (line too long):  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos, StandardCharsets.UTF_8);
            if (debugEnabled) {
                this.log.debug("doReadIdentification({}) line='{}'", (Object)this, (Object)str);
            }
            if (ident == null) {
                ident = new ArrayList<String>();
            }
            ident.add(str);
            if (!server && !str.startsWith("SSH-")) continue;
            return ident;
        } while (buffer.rpos() <= maxIdentSize);
        throw new StreamCorruptedException("Incorrect identification (too many header lines): size > " + maxIdentSize);
    }

    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        return NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "No KEX factories", new Object[0]));
    }

    protected Map<KexProposalOption, String> createProposal(String hostKeyTypes) throws IOException {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        String kexProposal = this.resolveSessionKexProposal(hostKeyTypes);
        proposal.put(KexProposalOption.ALGORITHMS, kexProposal);
        proposal.put(KexProposalOption.SERVERKEYS, hostKeyTypes);
        String ciphers = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "No cipher factories", new Object[0]));
        proposal.put(KexProposalOption.S2CENC, ciphers);
        proposal.put(KexProposalOption.C2SENC, ciphers);
        String macs = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "No MAC factories", new Object[0]));
        proposal.put(KexProposalOption.S2CMAC, macs);
        proposal.put(KexProposalOption.C2SMAC, macs);
        String compressions = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "No compression factories", new Object[0]));
        proposal.put(KexProposalOption.S2CCOMP, compressions);
        proposal.put(KexProposalOption.C2SCOMP, compressions);
        proposal.put(KexProposalOption.S2CLANG, "");
        proposal.put(KexProposalOption.C2SLANG, "");
        return proposal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> mergeProposals(Map<KexProposalOption, String> current, Map<KexProposalOption, String> proposal) {
        if (current == proposal) {
            return proposal;
        }
        Map<KexProposalOption, String> map = current;
        synchronized (map) {
            if (!current.isEmpty()) {
                current.clear();
            }
            if (GenericUtils.isEmpty(proposal)) {
                return proposal;
            }
            current.putAll(proposal);
        }
        return proposal;
    }

    protected void signalNegotiationStart(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationStart((SessionListener)l, c2sOptions, s2cOptions);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationStart(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationStart(this, c2sOptions, s2cOptions);
    }

    protected void signalNegotiationEnd(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationEnd((SessionListener)l, c2sOptions, s2cOptions, negotiatedGuess, reason);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationEnd(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationEnd(this, c2sOptions, s2cOptions, negotiatedGuess, null);
    }

    @Override
    public void disconnect(int reason, String msg) throws IOException {
        this.log.info("Disconnecting({}): {} - {}", this, SshConstants.getDisconnectReasonName(reason), msg);
        String languageTag = "";
        this.signalDisconnect(reason, msg, languageTag, true);
        Buffer buffer = this.createBuffer((byte)1, msg.length() + 16);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        long disconnectTimeoutMs = this.getLongProperty("disconnect-timeout", FactoryManager.DEFAULT_DISCONNECT_TIMEOUT);
        IoWriteFuture packetFuture = this.writePacket(buffer, disconnectTimeoutMs, TimeUnit.MILLISECONDS);
        packetFuture.addListener(future -> {
            Throwable t = future.getException();
            if (this.log.isDebugEnabled()) {
                if (t == null) {
                    this.log.debug("disconnect({}) operation successfully completed for reason={} [{}]", this, SshConstants.getDisconnectReasonName(reason), msg);
                } else {
                    this.log.debug("disconnect({}) operation failed ({}) for reason={} [{}]: {}", this, t.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(reason), msg, t.getMessage());
                }
            }
            if (t != null && this.log.isTraceEnabled()) {
                this.log.trace("disconnect(" + this + ") reason=" + SshConstants.getDisconnectReasonName(reason) + " failure details", t);
            }
            this.close(true);
        });
    }

    protected void handleDisconnect(Buffer buffer) throws Exception {
        int code = buffer.getInt();
        String message = buffer.getString();
        String languageTag = buffer.available() > 0 ? buffer.getString() : "";
        this.handleDisconnect(code, message, languageTag, buffer);
    }

    protected void handleDisconnect(int code, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDisconnect({}) SSH_MSG_DISCONNECT reason={}, [lang={}] msg={}", this, SshConstants.getDisconnectReasonName(code), lang, msg);
        }
        this.signalDisconnect(code, msg, lang, false);
        this.close(true);
    }

    protected void signalDisconnect(int code, String msg, String lang, boolean initiator) {
        block4: {
            try {
                this.invokeSessionSignaller(l -> {
                    this.signalDisconnect((SessionListener)l, code, msg, lang, initiator);
                    return null;
                });
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable e = GenericUtils.peelException(err);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("signalDisconnect(" + this + ") signal session disconnect details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = e.getSuppressed()) <= 0) break block4;
                for (Throwable s2 : suppressed) {
                    this.log.trace("signalDisconnect(" + this + ") suppressed session disconnect signalling", s2);
                }
            }
        }
    }

    protected void signalDisconnect(SessionListener listener, int code, String msg, String lang, boolean initiator) {
        if (listener == null) {
            return;
        }
        listener.sessionDisconnect(this, code, msg, lang, initiator);
    }

    @Override
    public void exceptionCaught(Throwable t) {
        int code;
        AbstractCloseable.State curState = (AbstractCloseable.State)((Object)this.state.get());
        if (!AbstractCloseable.State.Opened.equals((Object)curState) && !AbstractCloseable.State.Graceful.equals((Object)curState)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("exceptionCaught({}) ignore {} due to state={}, message='{}'", new Object[]{this, t.getClass().getSimpleName(), curState, t.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("exceptionCaught(" + this + ")[state=" + (Object)((Object)curState) + "] ignored exception details", t);
            }
            return;
        }
        this.log.warn("exceptionCaught({})[state={}] {}: {}", new Object[]{this, curState, t.getClass().getSimpleName(), t.getMessage()});
        Throwable cause = t.getCause();
        if (cause != null && GenericUtils.isSameReference(t, cause)) {
            cause = null;
        }
        if (cause != null) {
            this.log.warn("exceptionCaught({})[state={}] caused by {}: {}", new Object[]{this, curState, cause.getClass().getSimpleName(), cause.getMessage()});
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("exceptionCaught(" + this + ")[state=" + (Object)((Object)curState) + "] details", t);
            if (cause != null) {
                this.log.debug("exceptionCaught(" + this + ")[state=" + (Object)((Object)curState) + "] cause", cause);
            }
        }
        this.signalExceptionCaught(t);
        if (AbstractCloseable.State.Opened.equals((Object)curState) && t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
            block11: {
                try {
                    this.disconnect(code, t.getMessage());
                }
                catch (Throwable t2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("exceptionCaught({}) {} while disconnect with code={}: {}", this, t2.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(code), t2.getMessage());
                    }
                    if (!this.log.isTraceEnabled()) break block11;
                    this.log.trace("exceptionCaught(" + this + ")[code=" + SshConstants.getDisconnectReasonName(code) + "] disconnect exception details", t2);
                }
            }
            return;
        }
        this.close(true);
    }

    protected void signalExceptionCaught(Throwable t) {
        block4: {
            try {
                this.invokeSessionSignaller(l -> {
                    this.signalExceptionCaught((SessionListener)l, t);
                    return null;
                });
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable e = GenericUtils.peelException(err);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("signalExceptionCaught(" + this + ") signal session exception details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = e.getSuppressed()) <= 0) break block4;
                for (Throwable s2 : suppressed) {
                    this.log.trace("signalExceptionCaught(" + this + ") suppressed session exception signalling", s2);
                }
            }
        }
    }

    protected void signalExceptionCaught(SessionListener listener, Throwable t) {
        if (listener == null) {
            return;
        }
        listener.sessionException(this, t);
    }

    protected void signalSessionClosed() {
        block4: {
            try {
                this.invokeSessionSignaller(l -> {
                    this.signalSessionClosed((SessionListener)l);
                    return null;
                });
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable e = GenericUtils.peelException(err);
                this.log.warn("signalSessionClosed({}) {} while signal session closed: {}", this, e.getClass().getSimpleName(), e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("signalSessionClosed(" + this + ") signal session closed exception details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = e.getSuppressed()) <= 0) break block4;
                for (Throwable s2 : suppressed) {
                    this.log.trace("signalSessionClosed(" + this + ") suppressed session closed signalling", s2);
                }
            }
        }
    }

    protected void signalSessionClosed(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionClosed(this);
    }

    protected abstract ConnectionService getConnectionService();

    protected ForwardingFilter getForwardingFilter() {
        ConnectionService service = this.getConnectionService();
        return service == null ? null : service.getForwardingFilter();
    }

    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getLocalForwardsBindings() {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? Collections.emptyList() : filter.getLocalForwardsBindings();
    }

    @Override
    public boolean isLocalPortForwardingStartedForPort(int port) {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter != null && filter.isLocalPortForwardingStartedForPort(port);
    }

    @Override
    public NavigableSet<Integer> getStartedLocalPortForwards() {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? Collections.emptyNavigableSet() : filter.getStartedLocalPortForwards();
    }

    @Override
    public SshdSocketAddress getBoundLocalPortForward(int port) {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? null : filter.getBoundLocalPortForward(port);
    }

    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings() {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? Collections.emptyList() : filter.getRemoteForwardsBindings();
    }

    @Override
    public boolean isRemotePortForwardingStartedForPort(int port) {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter != null && filter.isRemotePortForwardingStartedForPort(port);
    }

    @Override
    public NavigableSet<Integer> getStartedRemotePortForwards() {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? Collections.emptyNavigableSet() : filter.getStartedRemotePortForwards();
    }

    @Override
    public SshdSocketAddress getBoundRemotePortForward(int port) {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter == null ? null : filter.getBoundRemotePortForward(port);
    }

    @Override
    public long getAuthTimeout() {
        return this.getLongProperty("auth-timeout", FactoryManager.DEFAULT_AUTH_TIMEOUT);
    }

    @Override
    public long getIdleTimeout() {
        return this.getLongProperty("idle-timeout", FactoryManager.DEFAULT_IDLE_TIMEOUT);
    }

    public String toString() {
        IoSession networkSession = this.getIoSession();
        SocketAddress peerAddress = networkSession == null ? null : networkSession.getRemoteAddress();
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + peerAddress + "]";
    }
}

