/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.process.childProcess;

import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.WindowsBridgeException;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeProcesses;
import com.gamedash.daemon.windows.process.childProcess.IWindowsBridgeChildProcessOnExitCallback;
import com.gamedash.daemon.windows.process.childProcess.IWindowsBridgeChildProcessOnOutputCallback;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcessException;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcessUser;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcesses;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeOutputItem;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WindowsBridgeChildProcess {
    private int id;
    private WindowsBridgeChildProcessUser user;
    private List<IWindowsBridgeChildProcessOnOutputCallback> onOutputCallbacks = new ArrayList<IWindowsBridgeChildProcessOnOutputCallback>();
    private List<IWindowsBridgeChildProcessOnExitCallback> onExitCallbacks = new ArrayList<IWindowsBridgeChildProcessOnExitCallback>();
    private Integer currentOutputCursor = null;
    private File workingDirectory = new File("C:\\");
    private Thread outputListenerThread;
    private boolean isListeningForExit = false;

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawn(String executable, String[] args) throws Exception {
        WindowsBridgeResult result;
        if (this.hasUser() && this.getUser().getSystemUser().hasStoredPassword()) {
            WindowsBridgeChildProcessUser user = this.getUser();
            result = WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcessAsUser(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath(), user.getSystemUser().getName(), user.getSystemUser().getStoredPassword()));
        } else {
            result = WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcess(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath()));
        }
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            this.id = result.getResultValueAsInteger();
            this.outputListenerThread = new Thread(() -> {
                try {
                    this.listenForOutput();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            this.outputListenerThread.start();
            new Thread(() -> {
                try {
                    this.listenForExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        finally {
            result.delete();
        }
    }

    public void stop() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().stopChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public int getExitCode() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessExitCode(this.getId()));
        return result.getResultValueAsInteger();
    }

    public void delete() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            WindowsBridgeChildProcesses.getAll().remove(this);
        }
        finally {
            result.delete();
        }
    }

    public void waitForExit() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.onExit(latch::countDown);
        latch.await();
    }

    public void onOutput(IWindowsBridgeChildProcessOnOutputCallback callback) {
        this.onOutputCallbacks.add(callback);
    }

    public void sendInput(String input) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessSendInput(this.getId(), input));
        try {
            if (result.isError()) {
                throw new WindowsBridgeException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void onExit(IWindowsBridgeChildProcessOnExitCallback callback) {
        this.onExitCallbacks.add(callback);
    }

    public List<WindowsBridgeProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessChildren(this.id));
        if (result.isError()) {
            throw new WindowsBridgeChildProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsBridgeProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public WindowsBridgeChildProcessUser getUser() {
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void setUser(WindowsBridgeChildProcessUser user) {
        this.user = user;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    public boolean hasExited() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessHasExited(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            boolean bl = result.getResultValueAsBoolean();
            return bl;
        }
        finally {
            result.delete();
        }
    }

    private void listenForExit() throws Exception {
        if (this.isListeningForExit) {
            throw new WindowsBridgeChildProcessException("Already listening for exit");
        }
        this.isListeningForExit = true;
        while (!this.hasExited()) {
            Thread.sleep(200L);
        }
        this.onExitCallbacks.forEach(IWindowsBridgeChildProcessOnExitCallback::method);
        if (this.outputListenerThread != null && this.outputListenerThread.isAlive()) {
            this.outputListenerThread.interrupt();
        }
    }

    private void listenForOutput() throws Exception {
        try {
            while (true) {
                int outputCount;
                if ((outputCount = this.getProcessOutputCount()) > 0 && (this.getCurrentOutputCursor() == null || outputCount - 1 > this.getCurrentOutputCursor())) {
                    int index;
                    ArrayList<String> newSerializedOutputItems = new ArrayList<String>();
                    int newLineCount = this.getCurrentOutputCursor() == null ? outputCount : outputCount - this.getCurrentOutputCursor();
                    int n = index = this.getCurrentOutputCursor() == null || this.getCurrentOutputCursor() == 0 ? 0 : 1;
                    while (index <= newLineCount - 1) {
                        int outputIndex = (this.getCurrentOutputCursor() == null ? 0 : this.getCurrentOutputCursor()) + index;
                        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessOutput(this.getId(), outputIndex));
                        if (result.isError()) {
                            throw new WindowsBridgeChildProcessException("Could not get output for index " + outputIndex + ": " + result.getErrorMessage());
                        }
                        newSerializedOutputItems.add(result.getResultValueAsString());
                        ++index;
                    }
                    newSerializedOutputItems.forEach(item -> {
                        WindowsBridgeOutputItem outputItem = new WindowsBridgeOutputItem((String)item, false);
                        this.onOutputCallbacks.forEach(callback -> callback.method(outputItem));
                    });
                    this.setCurrentOutputPointer(outputCount - 1);
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void waitForOutput() {
        try {
            while (!this.hasExited() || this.getCurrentOutputCursor() == null || this.getProcessOutputCount() - 1 != this.getCurrentOutputCursor()) {
                Thread.sleep(200L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getProcessOutputCount() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessOutputCount(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            int n = result.getResultValueAsInteger();
            return n;
        }
        finally {
            result.delete();
        }
    }

    private Integer getCurrentOutputCursor() {
        return this.currentOutputCursor;
    }

    private synchronized void setCurrentOutputPointer(Integer cursor) {
        this.currentOutputCursor = cursor;
    }
}

