/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.shutdown.Shutdown;
import com.gamedash.daemon.system.OperatingSystemArchitectureEnum;
import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;

public class OperatingSystem {
    public static OperatingSystemArchitectureEnum getArchitecture() {
        HashMap<String, OperatingSystemArchitectureEnum> archMap = new HashMap<String, OperatingSystemArchitectureEnum>();
        archMap.put("x86", OperatingSystemArchitectureEnum.x86);
        archMap.put("i386", OperatingSystemArchitectureEnum.x86);
        archMap.put("i486", OperatingSystemArchitectureEnum.x86);
        archMap.put("i586", OperatingSystemArchitectureEnum.x86);
        archMap.put("i686", OperatingSystemArchitectureEnum.x86);
        archMap.put("x86_64", OperatingSystemArchitectureEnum.x64);
        archMap.put("amd64", OperatingSystemArchitectureEnum.x64);
        if (!archMap.containsKey(SystemUtils.OS_ARCH)) {
            return null;
        }
        return (OperatingSystemArchitectureEnum)((Object)archMap.get(SystemUtils.OS_ARCH));
    }

    public static void shutdown() throws Exception {
        Shutdown.run();
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().shutdownOperatingSystem());
            if (result.isError()) {
                throw new Exception(result.getErrorMessage());
            }
        } else {
            ChildProcess childProcess = ChildProcesses.create();
            childProcess.spawn("shutdown", new String[0]);
            childProcess.waitForExit();
        }
    }

    public static void reboot() throws Exception {
        Shutdown.run();
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().rebootOperatingSystem());
            if (result.isError()) {
                throw new Exception(result.getErrorMessage());
            }
        } else {
            ChildProcess childProcess = ChildProcesses.create();
            childProcess.spawn("reboot", new String[0]);
            childProcess.waitForExit();
        }
    }
}

