/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup;

import com.gamedash.daemon.linux.cgroup.LinuxCGroups;
import com.gamedash.daemon.linux.cgroup.resource.cpu.CPUResource;
import com.gamedash.daemon.linux.cgroup.resource.disk.DiskResource;
import com.gamedash.daemon.linux.cgroup.resource.ram.RAMResource;

public class LinuxCGroup {
    private String name;
    private CPUResource cpu;
    private RAMResource ram;
    private DiskResource disk;

    public LinuxCGroup(String name) throws Exception {
        this.name = name;
        this.cpu = new CPUResource(this);
        this.ram = new RAMResource(this);
        this.disk = new DiskResource(this);
    }

    public String getName() {
        return this.name;
    }

    public CPUResource getCPU() {
        return this.cpu;
    }

    public RAMResource getRAM() {
        return this.ram;
    }

    public DiskResource getDisk() {
        return this.disk;
    }

    public void delete() throws Exception {
        if (this.cpu.isActive()) {
            this.cpu.destroy();
        }
        if (this.ram.isActive()) {
            this.ram.destroy();
        }
        if (this.disk.isActive()) {
            this.disk.destroy();
        }
        LinuxCGroups.getAll().remove(this);
    }
}

