/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.resource.usage.ResourceUsageResult;
import com.google.gson.annotations.SerializedName;
import spark.Request;
import spark.Response;

public class GetUsage
extends Route<Object> {
    public GetUsage(Request request, Response response) {
        super(request, response);
    }

    @Override
    public GetUsageResponse execute() throws Exception {
        int id = this.getParameters().get("id").getValue(Integer.class);
        if (!ChildProcesses.exists(id)) {
            throw new Exception("Process does not exist");
        }
        ChildProcess process = ChildProcesses.get(id);
        GetUsageResponse response = new GetUsageResponse();
        ResourceUsageResult result = process.getResourceUsage().query();
        response.getCpu().setPercentage(result.cpu);
        response.getRam().setMb(result.ram);
        return response;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    private static class GetUsageResponseRam {
        @SerializedName(value="mb")
        private long mb = 0L;

        private GetUsageResponseRam() {
        }

        public long getMb() {
            return this.mb;
        }

        public void setMb(long mb) {
            this.mb = mb;
        }
    }

    private static class GetUsageResponseCpu {
        @SerializedName(value="percentage")
        private int percentage = 0;

        private GetUsageResponseCpu() {
        }

        public int getPercentage() {
            return this.percentage;
        }

        public void setPercentage(int percentage) {
            this.percentage = percentage;
        }
    }

    private static class GetUsageResponse {
        @SerializedName(value="cpu")
        private GetUsageResponseCpu cpu = new GetUsageResponseCpu();
        @SerializedName(value="ram")
        private GetUsageResponseRam ram = new GetUsageResponseRam();

        private GetUsageResponse() {
        }

        public GetUsageResponseCpu getCpu() {
            return this.cpu;
        }

        public GetUsageResponseRam getRam() {
            return this.ram;
        }
    }
}

