/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import java.io.File;
import java.io.FileNotFoundException;
import org.zeroturnaround.zip.ZipUtil;
import spark.Request;
import spark.Response;

public class Unzip
extends Route<String> {
    public Unzip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        com.gamedash.daemon.fileSystem.file.File origin = com.gamedash.daemon.fileSystem.file.File.fromBase64(this.getParameters().get("origin").getValue());
        com.gamedash.daemon.fileSystem.file.File destination = com.gamedash.daemon.fileSystem.file.File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Origin file does not exist");
        }
        if (!destination.exists() || !destination.isDirectory()) {
            throw new FileNotFoundException("Destination directory does not exist");
        }
        ZipUtil.unpack(origin, (File)destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

