/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.license.Licenses;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlinks;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHosts;
import com.gamedash.daemon.license.License;
import com.gamedash.daemon.license.LicenseValidation;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Init {
    private static Logger logger = LoggerFactory.getLogger(Init.class);

    public static void init() throws Exception {
        Init.initLicense();
        if (!Authentication.isAuthenticated()) {
            throw new Exception("Could not authenticate");
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        futures.add(threadPool.submit(Init::initApiServer));
        futures.add(threadPool.submit(Init::initRemoteFileSystemHosts));
        futures.add(threadPool.submit(Init::initFileSystemHotlinks));
        threadPool.shutdown();
        threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void initLicense() throws Exception {
        String id = Licenses.getCurrent().getSystems().getCurrent().getId();
        logger.info("System ID " + id);
        License.validate();
        LicenseValidation.initPeriodicChecks();
    }

    private static Void initApiServer() {
        ApiServer.start();
        return null;
    }

    private static Void initRemoteFileSystemHosts() throws Exception {
        RemoteFileSystemHosts.start();
        return null;
    }

    private static Void initFileSystemHotlinks() throws Exception {
        Hotlinks.update();
        return null;
    }
}

