/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.beust.jcommander.JCommander;
import com.gamedash.daemon.Args;
import com.gamedash.daemon.Init;
import com.gamedash.daemon.Main;
import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.shutdown.Shutdown;
import com.gamedash.daemon.windows.WindowsBridge;
import java.io.File;
import java.net.InetAddress;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    public static Args args = new Args();
    public static Time initTime = Time.now();
    private static Logger logger = LoggerFactory.getLogger(Application.class);

    public void run(String[] argv) {
        JCommander.newBuilder().addObject(args).build().parse(argv);
        try {
            ApiClientConfigValidationResult apiClientConfigValidationResult;
            Config.setDefaultFile(Config.getFile("daemon.properties"));
            logger.info("Using " + Config.getDefaultFile().toFile().getPath() + " as default config file");
            if (FileSystem.getRootDirectory() == null) {
                FileSystem.setRootDirectory(FileSystemHelpers.getOwnDirectory(Main.class));
            }
            logger.info("Root directory set to " + FileSystem.getRootDirectory().getPath());
            if (SystemUtils.IS_OS_WINDOWS && !WindowsBridge.isInstalled()) {
                WindowsBridge.install();
            }
            if (!Application.isRunningWithElevatedPermissions()) {
                throw new Exception("Running as " + (SystemUtils.IS_OS_LINUX ? "root" : "administrator") + " is required");
            }
            Dependencies.install();
            if (Application.args.ip != null) {
                Network.setIp(InetAddress.getByName(Application.args.ip));
            }
            logger.info("Binding to IP " + Network.getIp().getHostAddress());
            if (Application.args.installOnly.booleanValue() || Installer.getState() == InstallerStateEnum.notInstalled || Installer.getState() == InstallerStateEnum.inProgress) {
                Installer.install();
                if (Application.args.installOnly.booleanValue()) {
                    System.exit(0);
                }
            }
            if (Application.args.shouldUninstall.booleanValue()) {
                if (Installer.getState() != InstallerStateEnum.installed) {
                    throw new Exception("Daemon is not currently installed");
                }
                Installer.uninstall();
                System.exit(0);
            }
            if (!Config.fileExists("daemon.properties")) {
                throw new ConfigException("daemon.properties does not exist");
            }
            if (Application.args.apiServerPort != null) {
                ApiServer.setPort(Application.args.apiServerPort);
            }
            if (Application.args.apiClientDomain != null) {
                ApiClientConfig.setDomain(Application.args.apiClientDomain);
            }
            if (Application.args.apiClientVersion != null) {
                ApiClientConfig.setVersion(Application.args.apiClientVersion);
            }
            if (!(apiClientConfigValidationResult = ApiClientConfig.validate()).isValid()) {
                throw new Exception(apiClientConfigValidationResult.getMessage() != null ? apiClientConfigValidationResult.getMessage() : "Invalid API client config");
            }
            if (KeyStore.hasFile().booleanValue()) {
                if (!KeyStore.getFile().exists()) {
                    throw new Exception("Keystore file does not exist");
                }
                if (!KeyStore.hasPassword()) {
                    throw new Exception("Keystore password is not set");
                }
                if (KeyStore.isSelfSigned().booleanValue()) {
                    logger.warn("Certificate is self signed");
                }
            }
            Shutdown.registerHook();
            Init.init();
            Nodes.getSelf().getStatus().update(true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void shutdown() throws Exception {
        Shutdown.run();
    }

    public static boolean isRunningWithElevatedPermissions() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return System.getProperty("user.name").equals("root");
        }
        return true;
    }

    public static void setRootDirectory(File directory) {
        FileSystem.setRootDirectory(directory);
    }
}

