/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractAgentClient
extends AbstractLoggingBean {
    private final Buffer buffer = new ByteArrayBuffer();
    private final SshAgent agent;

    protected AbstractAgentClient(SshAgent agent) {
        this.agent = agent;
    }

    public synchronized void messageReceived(Buffer message) throws IOException {
        this.buffer.putBuffer(message);
        int avail = this.buffer.available();
        if (avail < 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received message total length ({}) below minimum ({})", (Object)avail, (Object)4);
            }
            return;
        }
        int rpos = this.buffer.rpos();
        int len = this.buffer.getInt();
        if (len < 0) {
            throw new StreamCorruptedException("Illogical message length: " + len);
        }
        this.buffer.rpos(rpos);
        avail = this.buffer.available();
        if (avail < len + 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received request length ({}) below minimum ({})", (Object)avail, (Object)(len + 4));
            }
            return;
        }
        ByteArrayBuffer rep = new ByteArrayBuffer();
        rep.putInt(0L);
        ((Buffer)rep).rpos(((Buffer)rep).wpos());
        ByteArrayBuffer req = new ByteArrayBuffer(this.buffer.getBytes());
        int cmd = -1;
        try {
            cmd = req.getUByte();
            this.process(cmd, req, rep);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to handle command={}: {}", e.getClass().getSimpleName(), cmd, e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received command=" + cmd + " handling failure details", e);
            }
            rep.clear();
            rep.putInt(0L);
            ((Buffer)rep).rpos(((Buffer)rep).wpos());
            rep.putInt(1L);
            ((Buffer)rep).putByte((byte)30);
        }
        this.reply(this.prepare(rep));
    }

    protected void process(int cmd, Buffer req, Buffer rep) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("process(cmd={})", (Object)SshAgentConstants.getCommandMessageName(cmd));
        }
        switch (cmd) {
            case 11: {
                LinkedList keys;
                Iterable<? extends Map.Entry<PublicKey, String>> ids = this.agent.getIdentities();
                if (ids instanceof Collection) {
                    keys = (LinkedList)ids;
                } else {
                    LinkedList c = new LinkedList();
                    for (Map.Entry<PublicKey, String> entry : ids) {
                        c.add(entry);
                    }
                    keys = c;
                }
                rep.putByte((byte)12);
                rep.putInt(keys.size());
                for (Map.Entry key : keys) {
                    rep.putPublicKey((PublicKey)key.getKey());
                    rep.putString((String)key.getValue());
                }
                break;
            }
            case 13: {
                PublicKey signingKey = req.getPublicKey();
                byte[] data = req.getBytes();
                int flags = req.getInt();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_SIGN_REQUEST key={}, flags=0x{}, data={}", signingKey.getAlgorithm(), Integer.toHexString(flags), BufferUtils.toHex(':', data));
                }
                String keyType = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(signingKey), "Cannot resolve key type of %s", (Object)signingKey.getClass().getSimpleName());
                byte[] byArray = this.agent.sign(null, signingKey, data);
                ByteArrayBuffer sig = new ByteArrayBuffer(keyType.length() + byArray.length + 64, false);
                sig.putString(keyType);
                sig.putBytes(byArray);
                rep.putByte((byte)14);
                rep.putBytes(((Buffer)sig).array(), ((Buffer)sig).rpos(), sig.available());
                break;
            }
            case 17: {
                KeyPair keyToAdd = req.getKeyPair();
                String comment = req.getString();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_ADD_IDENTITY comment={}", (Object)comment);
                }
                this.agent.addIdentity(keyToAdd, comment);
                rep.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey keyToRemove = req.getPublicKey();
                if (debugEnabled) {
                    this.log.debug("SSH2_AGENTC_REMOVE_IDENTITY {}", (Object)keyToRemove.getClass().getSimpleName());
                }
                this.agent.removeIdentity(keyToRemove);
                rep.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                rep.putByte((byte)6);
                break;
            }
            default: {
                if (debugEnabled) {
                    this.log.debug("Unknown command: {}", (Object)SshAgentConstants.getCommandMessageName(cmd));
                }
                rep.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buf) {
        int len = buf.available();
        int rpos = buf.rpos();
        int wpos = buf.wpos();
        buf.rpos(rpos - 4);
        buf.wpos(rpos - 4);
        buf.putInt(len);
        buf.wpos(wpos);
        return buf;
    }

    protected abstract void reply(Buffer var1) throws IOException;
}

