/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.linux;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessPriorityEnum;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendant;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendants;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinuxProcess
implements IProcess {
    private int id;
    private ProcessPriorityEnum priority = ProcessPriorityEnum.normal;
    private LinuxProcessDescendants descendants;

    public LinuxProcess(int id) {
        this.id = id;
        this.descendants = new LinuxProcessDescendants(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() throws Exception {
        return this.readProcStatusFile().get("Name");
    }

    @Override
    public String[] getCommandLine() throws Exception {
        return Files.readString(Paths.get("/proc/" + this.getId() + "/cmdline", new String[0])).split("\u0000");
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return Files.readSymbolicLink(Paths.get("/proc/" + this.getId() + "/cwd", new String[0])).toFile();
    }

    @Override
    public void kill() throws Exception {
        this.kill("SIGKILL");
    }

    @Override
    public void kill(String signal) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        childProcess.setUseShell(false);
        childProcess.spawn("kill", new String[]{"-" + signal, Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public void stop() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        childProcess.spawn("kill", new String[]{"-s", "TERM", Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public ProcessPriorityEnum getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ProcessPriorityEnum priority) {
        this.priority = priority;
    }

    @Override
    public List<IProcess> getAllChildren() throws Exception {
        ArrayList<IProcess> children = new ArrayList<IProcess>();
        for (LinuxProcessDescendant descendant : LinuxProcessDescendants.find(this)) {
            children.add(descendant.getProcess());
        }
        return children;
    }

    public List<IProcess> getChildren() throws Exception {
        ArrayList<IProcess> children = new ArrayList<IProcess>();
        for (LinuxProcessDescendant descendant : this.descendants.getImmediate().getAll()) {
            children.add(descendant.getProcess());
        }
        return children;
    }

    public List<LinuxProcess> getThreads() throws Exception {
        ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
        File[] files = new File("/proc/" + this.getId() + "/task").listFiles();
        if (files == null) {
            return processes;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            processes.add((LinuxProcess)Processes.get(Integer.parseInt(file.getName())));
        }
        return processes;
    }

    public Map<String, String> readProcStatusFile() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get("/proc/" + this.getId() + "/status", new String[0]));
        HashMap<String, String> output = new HashMap<String, String>();
        for (String line : lines) {
            String[] lineBits = line.split(":", 2);
            output.put(lineBits[0], lineBits[1].split("\\s+", 2)[1]);
        }
        return output;
    }

    public boolean equals(Object process) {
        return process instanceof IProcess && ((IProcess)process).getId() == this.getId();
    }
}

