/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.resource.limit;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.process.childProcess.resource.limit.api.IResourceLimitApi;
import com.gamedash.daemon.process.childProcess.resource.limit.api.LinuxResourceLimitApi;
import com.gamedash.daemon.process.childProcess.resource.limit.api.WindowsResourceLimitApi;
import com.gamedash.daemon.system.UnsupportedOperatingSystemException;
import org.apache.commons.lang3.SystemUtils;

public class ResourceLimits {
    private ChildProcess childProcess;
    private IResourceLimitApi api;
    private CPUResourceLimit cpu;
    private RAMResourceLimit ram;
    private DiskResourceLimit disk;

    public ResourceLimits(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public CPUResourceLimit getCPU() {
        return this.cpu;
    }

    public RAMResourceLimit getRam() {
        return this.ram;
    }

    public DiskResourceLimit getDisk() {
        return this.disk;
    }

    public void setCPU(CPUResourceLimit cpu) throws Exception {
        this.cpu = cpu;
        this.getApi().setCPU(cpu);
    }

    public void setRAM(RAMResourceLimit ram) throws Exception {
        this.ram = ram;
        this.getApi().setRAM(ram);
    }

    public void setDisk(DiskResourceLimit disk) throws Exception {
        this.disk = disk;
        this.getApi().setDisk(disk);
    }

    private IResourceLimitApi getApi() throws UnsupportedOperatingSystemException {
        if (this.api == null) {
            if (SystemUtils.IS_OS_LINUX) {
                this.api = new LinuxResourceLimitApi(this.childProcess);
            } else if (SystemUtils.IS_OS_WINDOWS) {
                this.api = new WindowsResourceLimitApi(this.childProcess);
            } else {
                throw new UnsupportedOperatingSystemException("Operating system is not supported");
            }
        }
        return this.api;
    }
}

