/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcesses;
import com.gamedash.daemon.process.platform.windows.WindowsProcess;
import com.gamedash.daemon.process.platform.windows.WindowsProcesses;
import com.gamedash.daemon.system.UnsupportedOperatingSystemException;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeProcesses;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class Processes {
    private static List<Process> processes = new ArrayList<Process>();

    public static List<IProcess> getAll() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            ArrayList<IProcess> processes = new ArrayList<IProcess>();
            File[] files = new File("/proc").listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || !StringUtils.isNumeric(file.getName())) continue;
                    processes.add(Processes.get(Integer.parseInt(file.getName())));
                }
            }
            return processes;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            ArrayList<IProcess> processes = new ArrayList<IProcess>();
            for (WindowsBridgeProcess process : WindowsBridgeProcesses.getAll()) {
                processes.add(Processes.get(process.getId()));
            }
            return processes;
        }
        return new ArrayList<IProcess>();
    }

    public static IProcess get(int id) throws Exception {
        IProcess process;
        if (SystemUtils.IS_OS_LINUX) {
            process = new LinuxProcess(id);
        } else if (SystemUtils.IS_OS_WINDOWS) {
            process = new WindowsProcess(id);
        } else {
            throw new UnsupportedOperatingSystemException();
        }
        return process;
    }

    public static boolean exists(int id) throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return LinuxProcesses.exists(id);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WindowsProcesses.exists(id);
        }
        throw new UnsupportedOperatingSystemException();
    }
}

