/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.packages;

import com.gamedash.daemon.linux.Linux;
import com.gamedash.daemon.linux.LinuxDistroEnum;
import com.gamedash.daemon.linux.LinuxRelease;
import com.gamedash.daemon.linux.packages.CentOS;
import com.gamedash.daemon.linux.packages.Debian;
import com.gamedash.daemon.linux.packages.IDistro;
import com.gamedash.daemon.linux.packages.RHEL;
import com.gamedash.daemon.linux.packages.Ubuntu;

public class LinuxPackage {
    private String name;
    private IDistro flavorInstance;

    public LinuxPackage(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void install() throws Exception {
        this.getInstance().install();
    }

    public void uninstall() throws Exception {
        this.getInstance().uninstall();
    }

    private synchronized IDistro getInstance() throws Exception {
        if (this.flavorInstance == null) {
            LinuxRelease distro = Linux.getRelease();
            IDistro instance = null;
            if (distro.getDistro() == LinuxDistroEnum.centos) {
                instance = new CentOS(this);
            } else if (distro.getDistro() == LinuxDistroEnum.rhel) {
                instance = new RHEL(this);
            } else if (distro.getDistro() == LinuxDistroEnum.debian) {
                instance = new Debian(this);
            } else if (distro.getDistro() == LinuxDistroEnum.ubuntu) {
                instance = new Ubuntu(this);
            }
            this.flavorInstance = instance;
        }
        return this.flavorInstance;
    }
}

