/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource.ram;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.RAMController;
import com.gamedash.daemon.linux.cgroup.resource.Common;
import com.gamedash.daemon.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class RAMResource
extends Common
implements IResource {
    private LinuxCGroup cGroup;
    private int mb;

    public RAMResource(LinuxCGroup cGroup) {
        super(cGroup, new RAMController());
        this.cGroup = cGroup;
    }

    public int getMb() {
        return this.mb;
    }

    public void setMB(int mb) throws Exception {
        if (!this.isActive()) {
            this.create();
        }
        this.mb = mb;
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r memory.limit_in_bytes=" + mb + "m " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set CPU shares");
        }
    }

    @Override
    public void limitProcess(IProcess process) throws Exception {
        this.classifyProcess(process);
    }
}

